/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.authentication;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import net.zaiyers.Channels.lib.bson.BsonDocument;
import net.zaiyers.Channels.lib.bson.BsonInt32;
import net.zaiyers.Channels.lib.bson.BsonString;
import net.zaiyers.Channels.lib.mongodb.internal.HexUtils;

public final class NativeAuthenticationHelper {
    public static String createAuthenticationHash(String userName, char[] password) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(userName.length() + 20 + password.length);
        try {
            bout.write(userName.getBytes(StandardCharsets.UTF_8));
            bout.write(":mongo:".getBytes(StandardCharsets.UTF_8));
            bout.write(new String(password).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ioe) {
            throw new RuntimeException("impossible", ioe);
        }
        return HexUtils.hexMD5(bout.toByteArray());
    }

    public static BsonDocument getAuthCommand(String userName, char[] password, String nonce) {
        return NativeAuthenticationHelper.getAuthCommand(userName, NativeAuthenticationHelper.createAuthenticationHash(userName, password), nonce);
    }

    public static BsonDocument getAuthCommand(String userName, String authHash, String nonce) {
        String key = nonce + userName + authHash;
        BsonDocument cmd = new BsonDocument();
        cmd.put("authenticate", new BsonInt32(1));
        cmd.put("user", new BsonString(userName));
        cmd.put("nonce", new BsonString(nonce));
        cmd.put("key", new BsonString(HexUtils.hexMD5(key.getBytes(StandardCharsets.UTF_8))));
        return cmd;
    }

    public static BsonDocument getNonceCommand() {
        return new BsonDocument("getnonce", new BsonInt32(1));
    }

    private NativeAuthenticationHelper() {
    }
}

