/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.connection;

import java.util.concurrent.atomic.AtomicInteger;
import net.zaiyers.Channels.lib.mongodb.internal.binding.ReferenceCounted;

abstract class AbstractReferenceCounted
implements ReferenceCounted {
    private final AtomicInteger referenceCount = new AtomicInteger(1);

    AbstractReferenceCounted() {
    }

    @Override
    public int getCount() {
        return this.referenceCount.get();
    }

    @Override
    public ReferenceCounted retain() {
        if (this.referenceCount.incrementAndGet() == 1) {
            throw new IllegalStateException("Attempted to increment the reference count when it is already 0");
        }
        return this;
    }

    @Override
    public int release() {
        int decrementedValue = this.referenceCount.decrementAndGet();
        if (decrementedValue < 0) {
            throw new IllegalStateException("Attempted to decrement the reference count below 0");
        }
        return decrementedValue;
    }
}

