/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.connection;

import java.util.Objects;
import net.zaiyers.Channels.lib.mongodb.annotations.Immutable;
import net.zaiyers.Channels.lib.mongodb.annotations.NotThreadSafe;

@Immutable
public final class InternalConnectionPoolSettings {
    private final boolean prestartAsyncWorkManager;

    private InternalConnectionPoolSettings(Builder builder) {
        this.prestartAsyncWorkManager = builder.prestartAsyncWorkManager;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isPrestartAsyncWorkManager() {
        return this.prestartAsyncWorkManager;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalConnectionPoolSettings that = (InternalConnectionPoolSettings)o;
        return this.prestartAsyncWorkManager == that.prestartAsyncWorkManager;
    }

    public int hashCode() {
        return Objects.hash(this.prestartAsyncWorkManager);
    }

    public String toString() {
        return "InternalConnectionPoolSettings{prestartAsyncWorkManager=" + this.prestartAsyncWorkManager + '}';
    }

    @NotThreadSafe
    public static final class Builder {
        private boolean prestartAsyncWorkManager = false;

        private Builder() {
        }

        public Builder prestartAsyncWorkManager(boolean prestart) {
            this.prestartAsyncWorkManager = prestart;
            return this;
        }

        public InternalConnectionPoolSettings build() {
            return new InternalConnectionPoolSettings(this);
        }
    }
}

