/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.connection;

import java.util.concurrent.atomic.AtomicBoolean;
import net.zaiyers.Channels.lib.bson.types.ObjectId;
import net.zaiyers.Channels.lib.mongodb.MongoCommandException;
import net.zaiyers.Channels.lib.mongodb.MongoException;
import net.zaiyers.Channels.lib.mongodb.MongoNodeIsRecoveringException;
import net.zaiyers.Channels.lib.mongodb.MongoNotPrimaryException;
import net.zaiyers.Channels.lib.mongodb.MongoSocketException;
import net.zaiyers.Channels.lib.mongodb.MongoSocketReadTimeoutException;
import net.zaiyers.Channels.lib.mongodb.annotations.ThreadSafe;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.connection.ClusterConnectionMode;
import net.zaiyers.Channels.lib.mongodb.connection.ServerConnectionState;
import net.zaiyers.Channels.lib.mongodb.connection.ServerDescription;
import net.zaiyers.Channels.lib.mongodb.connection.ServerId;
import net.zaiyers.Channels.lib.mongodb.connection.ServerType;
import net.zaiyers.Channels.lib.mongodb.event.ServerClosedEvent;
import net.zaiyers.Channels.lib.mongodb.event.ServerDescriptionChangedEvent;
import net.zaiyers.Channels.lib.mongodb.event.ServerListener;
import net.zaiyers.Channels.lib.mongodb.event.ServerOpeningEvent;
import net.zaiyers.Channels.lib.mongodb.internal.async.ErrorHandlingResultCallback;
import net.zaiyers.Channels.lib.mongodb.internal.async.SingleResultCallback;
import net.zaiyers.Channels.lib.mongodb.internal.connection.AsyncConnection;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ClusterClock;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ClusterClockAdvancingSessionContext;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ClusterableServer;
import net.zaiyers.Channels.lib.mongodb.internal.connection.CommandProtocol;
import net.zaiyers.Channels.lib.mongodb.internal.connection.Connection;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ConnectionFactory;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ConnectionPool;
import net.zaiyers.Channels.lib.mongodb.internal.connection.InternalConnection;
import net.zaiyers.Channels.lib.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ProtocolExecutor;
import net.zaiyers.Channels.lib.mongodb.internal.diagnostics.logging.Logger;
import net.zaiyers.Channels.lib.mongodb.internal.diagnostics.logging.Loggers;
import net.zaiyers.Channels.lib.mongodb.internal.session.SessionContext;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

@ThreadSafe
public class LoadBalancedServer
implements ClusterableServer {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ServerId serverId;
    private final ConnectionPool connectionPool;
    private final ConnectionFactory connectionFactory;
    private final ServerListener serverListener;
    private final ClusterClock clusterClock;

    public LoadBalancedServer(ServerId serverId, ConnectionPool connectionPool, ConnectionFactory connectionFactory, ServerListener serverListener, ClusterClock clusterClock) {
        this.serverId = serverId;
        this.connectionPool = connectionPool;
        this.connectionFactory = connectionFactory;
        this.serverListener = serverListener;
        this.clusterClock = clusterClock;
        serverListener.serverOpening(new ServerOpeningEvent(serverId));
        serverListener.serverDescriptionChanged(new ServerDescriptionChangedEvent(serverId, ServerDescription.builder().ok(true).state(ServerConnectionState.CONNECTED).type(ServerType.LOAD_BALANCER).address(serverId.getAddress()).build(), ServerDescription.builder().address(serverId.getAddress()).state(ServerConnectionState.CONNECTING).build()));
    }

    @Override
    public void resetToConnecting() {
    }

    @Override
    public void invalidate() {
    }

    private void invalidate(Throwable t, @Nullable ObjectId serviceId, int generation) {
        if (!this.isClosed()) {
            if (t instanceof MongoSocketException && !(t instanceof MongoSocketReadTimeoutException)) {
                if (serviceId != null) {
                    this.connectionPool.invalidate(serviceId, generation);
                }
            } else if ((t instanceof MongoNotPrimaryException || t instanceof MongoNodeIsRecoveringException) && SHUTDOWN_CODES.contains(((MongoCommandException)t).getErrorCode()) && serviceId != null) {
                this.connectionPool.invalidate(serviceId, generation);
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.connectionPool.close();
            this.serverListener.serverClosed(new ServerClosedEvent(this.serverId));
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void connect() {
    }

    @Override
    public Connection getConnection() {
        Assertions.isTrue("open", !this.isClosed());
        return this.connectionFactory.create(this.connectionPool.get(), new LoadBalancedServerProtocolExecutor(), ClusterConnectionMode.LOAD_BALANCED);
    }

    @Override
    public void getConnectionAsync(SingleResultCallback<AsyncConnection> callback) {
        Assertions.isTrue("open", !this.isClosed());
        this.connectionPool.getAsync((result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult(this.connectionFactory.createAsync((InternalConnection)result, new LoadBalancedServerProtocolExecutor(), ClusterConnectionMode.LOAD_BALANCED), null);
            }
        });
    }

    @Override
    public int operationCount() {
        return -1;
    }

    ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    private class LoadBalancedServerProtocolExecutor
    implements ProtocolExecutor {
        private LoadBalancedServerProtocolExecutor() {
        }

        @Override
        public <T> T execute(CommandProtocol<T> protocol, InternalConnection connection, SessionContext sessionContext) {
            try {
                protocol.sessionContext(new ClusterClockAdvancingSessionContext(sessionContext, LoadBalancedServer.this.clusterClock));
                return protocol.execute(connection);
            }
            catch (MongoWriteConcernWithResponseException e) {
                return (T)e.getResponse();
            }
            catch (MongoException e) {
                this.handleExecutionException(connection, sessionContext, e);
                throw e;
            }
        }

        @Override
        public <T> void executeAsync(CommandProtocol<T> protocol, InternalConnection connection, SessionContext sessionContext, SingleResultCallback<T> callback) {
            protocol.sessionContext(new ClusterClockAdvancingSessionContext(sessionContext, LoadBalancedServer.this.clusterClock));
            protocol.executeAsync(connection, ErrorHandlingResultCallback.errorHandlingCallback((result, t) -> {
                if (t != null) {
                    if (t instanceof MongoWriteConcernWithResponseException) {
                        callback.onResult(((MongoWriteConcernWithResponseException)t).getResponse(), null);
                    } else {
                        this.handleExecutionException(connection, sessionContext, t);
                        callback.onResult(null, t);
                    }
                } else {
                    callback.onResult(result, null);
                }
            }, LOGGER));
        }

        private void handleExecutionException(InternalConnection connection, SessionContext sessionContext, Throwable t) {
            LoadBalancedServer.this.invalidate(t, connection.getDescription().getServiceId(), connection.getGeneration());
            if (t instanceof MongoSocketException && sessionContext.hasSession()) {
                sessionContext.markSessionDirty();
            }
        }
    }
}

