/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.connection.tlschannel.impl;

import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLProtocolException;

public final class TlsExplorer {
    public static final int RECORD_HEADER_SIZE = 5;

    private TlsExplorer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRequiredSize(ByteBuffer source) {
        if (source.remaining() < 5) {
            throw new BufferUnderflowException();
        }
        ((Buffer)source).mark();
        try {
            byte firstByte = source.get();
            source.get();
            byte thirdByte = source.get();
            if ((firstByte & 0x80) != 0 && thirdByte == 1) {
                int n = 5;
                return n;
            }
            int n = ((source.get() & 0xFF) << 8 | source.get() & 0xFF) + 5;
            return n;
        }
        finally {
            ((Buffer)source).reset();
        }
    }

    public static Map<Integer, SNIServerName> explore(ByteBuffer source) throws SSLProtocolException {
        if (source.remaining() < 5) {
            throw new BufferUnderflowException();
        }
        ((Buffer)source).mark();
        try {
            byte firstByte = source.get();
            TlsExplorer.ignore(source, 1);
            byte thirdByte = source.get();
            if ((firstByte & 0x80) != 0 && thirdByte == 1) {
                HashMap<Integer, SNIServerName> hashMap = new HashMap<Integer, SNIServerName>();
                return hashMap;
            }
            if (firstByte == 22) {
                Map<Integer, SNIServerName> map = TlsExplorer.exploreTLSRecord(source, firstByte);
                return map;
            }
            throw new SSLProtocolException("Not handshake record");
        }
        finally {
            ((Buffer)source).reset();
        }
    }

    private static Map<Integer, SNIServerName> exploreTLSRecord(ByteBuffer input, byte firstByte) throws SSLProtocolException {
        if (firstByte != 22) {
            throw new SSLProtocolException("Not handshake record");
        }
        int recordLength = TlsExplorer.getInt16(input);
        if (recordLength > input.remaining()) {
            throw new BufferUnderflowException();
        }
        return TlsExplorer.exploreHandshake(input, recordLength);
    }

    private static Map<Integer, SNIServerName> exploreHandshake(ByteBuffer input, int recordLength) throws SSLProtocolException {
        byte handshakeType = input.get();
        if (handshakeType != 1) {
            throw new SSLProtocolException("Not initial handshaking");
        }
        int handshakeLength = TlsExplorer.getInt24(input);
        if (handshakeLength > recordLength - 4) {
            throw new SSLProtocolException("Handshake message spans multiple records");
        }
        ((Buffer)input).limit(handshakeLength + input.position());
        return TlsExplorer.exploreClientHello(input);
    }

    private static Map<Integer, SNIServerName> exploreClientHello(ByteBuffer input) throws SSLProtocolException {
        TlsExplorer.ignore(input, 2);
        TlsExplorer.ignore(input, 32);
        TlsExplorer.ignoreByteVector8(input);
        TlsExplorer.ignoreByteVector16(input);
        TlsExplorer.ignoreByteVector8(input);
        if (input.remaining() > 0) {
            return TlsExplorer.exploreExtensions(input);
        }
        return new HashMap<Integer, SNIServerName>();
    }

    private static Map<Integer, SNIServerName> exploreExtensions(ByteBuffer input) throws SSLProtocolException {
        int extLen;
        for (int length = TlsExplorer.getInt16(input); length > 0; length -= extLen + 4) {
            int extType = TlsExplorer.getInt16(input);
            extLen = TlsExplorer.getInt16(input);
            if (extType == 0) {
                return TlsExplorer.exploreSNIExt(input, extLen);
            }
            TlsExplorer.ignore(input, extLen);
        }
        return new HashMap<Integer, SNIServerName>();
    }

    private static Map<Integer, SNIServerName> exploreSNIExt(ByteBuffer input, int extLen) throws SSLProtocolException {
        HashMap<Integer, SNIServerName> sniMap = new HashMap<Integer, SNIServerName>();
        int remains = extLen;
        if (extLen >= 2) {
            int listLen = TlsExplorer.getInt16(input);
            if (listLen == 0 || listLen + 2 != extLen) {
                throw new SSLProtocolException("Invalid server name indication extension");
            }
            remains -= 2;
            while (remains > 0) {
                SNIServerName serverName;
                int code = TlsExplorer.getInt8(input);
                int snLen = TlsExplorer.getInt16(input);
                if (snLen > remains) {
                    throw new SSLProtocolException("Not enough data to fill declared vector size");
                }
                byte[] encoded = new byte[snLen];
                input.get(encoded);
                if (code == 0) {
                    if (encoded.length == 0) {
                        throw new SSLProtocolException("Empty HostName in server name indication");
                    }
                    serverName = new SNIHostName(encoded);
                } else {
                    serverName = new UnknownServerName(code, encoded);
                }
                if (sniMap.put(serverName.getType(), serverName) != null) {
                    throw new SSLProtocolException("Duplicated server name of type " + serverName.getType());
                }
                remains -= encoded.length + 3;
            }
        } else if (extLen == 0) {
            throw new SSLProtocolException("Not server name indication extension in client");
        }
        if (remains != 0) {
            throw new SSLProtocolException("Invalid server name indication extension");
        }
        return sniMap;
    }

    private static int getInt8(ByteBuffer input) {
        return input.get();
    }

    private static int getInt16(ByteBuffer input) {
        return (input.get() & 0xFF) << 8 | input.get() & 0xFF;
    }

    private static int getInt24(ByteBuffer input) {
        return (input.get() & 0xFF) << 16 | (input.get() & 0xFF) << 8 | input.get() & 0xFF;
    }

    private static void ignoreByteVector8(ByteBuffer input) {
        TlsExplorer.ignore(input, TlsExplorer.getInt8(input));
    }

    private static void ignoreByteVector16(ByteBuffer input) {
        TlsExplorer.ignore(input, TlsExplorer.getInt16(input));
    }

    private static void ignore(ByteBuffer input, int length) {
        if (length != 0) {
            ((Buffer)input).position(input.position() + length);
        }
    }

    private static class UnknownServerName
    extends SNIServerName {
        UnknownServerName(int code, byte[] encoded) {
            super(code, encoded);
        }
    }
}

