/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.operation;

import java.util.concurrent.TimeUnit;
import net.zaiyers.Channels.lib.bson.BsonDocument;
import net.zaiyers.Channels.lib.bson.BsonString;
import net.zaiyers.Channels.lib.bson.BsonValue;
import net.zaiyers.Channels.lib.bson.codecs.BsonDocumentCodec;
import net.zaiyers.Channels.lib.bson.codecs.Decoder;
import net.zaiyers.Channels.lib.mongodb.MongoNamespace;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.client.model.Collation;
import net.zaiyers.Channels.lib.mongodb.connection.ConnectionDescription;
import net.zaiyers.Channels.lib.mongodb.internal.async.SingleResultCallback;
import net.zaiyers.Channels.lib.mongodb.internal.binding.AsyncReadBinding;
import net.zaiyers.Channels.lib.mongodb.internal.binding.ReadBinding;
import net.zaiyers.Channels.lib.mongodb.internal.operation.AsyncReadOperation;
import net.zaiyers.Channels.lib.mongodb.internal.operation.CommandOperationHelper;
import net.zaiyers.Channels.lib.mongodb.internal.operation.DocumentHelper;
import net.zaiyers.Channels.lib.mongodb.internal.operation.OperationReadConcernHelper;
import net.zaiyers.Channels.lib.mongodb.internal.operation.ReadOperation;
import net.zaiyers.Channels.lib.mongodb.internal.session.SessionContext;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

public class CountOperation
implements AsyncReadOperation<Long>,
ReadOperation<Long> {
    private static final Decoder<BsonDocument> DECODER = new BsonDocumentCodec();
    private final MongoNamespace namespace;
    private boolean retryReads;
    private BsonDocument filter;
    private BsonValue hint;
    private long skip;
    private long limit;
    private long maxTimeMS;
    private Collation collation;

    public CountOperation(MongoNamespace namespace) {
        this.namespace = Assertions.notNull("namespace", namespace);
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public CountOperation filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public CountOperation retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    public BsonValue getHint() {
        return this.hint;
    }

    public CountOperation hint(BsonValue hint) {
        this.hint = hint;
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public CountOperation limit(long limit) {
        this.limit = limit;
        return this;
    }

    public long getSkip() {
        return this.skip;
    }

    public CountOperation skip(long skip) {
        this.skip = skip;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public CountOperation maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public CountOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public Long execute(ReadBinding binding) {
        return CommandOperationHelper.executeRetryableRead(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), DECODER, this.transformer(), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<Long> callback) {
        CommandOperationHelper.executeRetryableReadAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), DECODER, this.asyncTransformer(), this.retryReads, callback);
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, Long> transformer() {
        return (result, source, connection) -> result.getNumber("n").longValue();
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, Long> asyncTransformer() {
        return (result, source, connection) -> result.getNumber("n").longValue();
    }

    private CommandOperationHelper.CommandCreator getCommandCreator(SessionContext sessionContext) {
        return (serverDescription, connectionDescription) -> this.getCommand(sessionContext, connectionDescription);
    }

    private BsonDocument getCommand(SessionContext sessionContext, ConnectionDescription connectionDescription) {
        BsonDocument document = new BsonDocument("count", new BsonString(this.namespace.getCollectionName()));
        OperationReadConcernHelper.appendReadConcernToCommand(sessionContext, connectionDescription.getMaxWireVersion(), document);
        DocumentHelper.putIfNotNull(document, "query", this.filter);
        DocumentHelper.putIfNotZero(document, "limit", this.limit);
        DocumentHelper.putIfNotZero(document, "skip", this.skip);
        DocumentHelper.putIfNotNull(document, "hint", this.hint);
        DocumentHelper.putIfNotZero(document, "maxTimeMS", this.maxTimeMS);
        if (this.collation != null) {
            document.put("collation", this.collation.asDocument());
        }
        return document;
    }
}

