/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.operation;

import java.util.concurrent.TimeUnit;
import net.zaiyers.Channels.lib.bson.BsonBoolean;
import net.zaiyers.Channels.lib.bson.BsonDocument;
import net.zaiyers.Channels.lib.bson.BsonInt32;
import net.zaiyers.Channels.lib.bson.BsonInt64;
import net.zaiyers.Channels.lib.bson.BsonValue;
import net.zaiyers.Channels.lib.bson.codecs.Decoder;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.connection.ConnectionDescription;
import net.zaiyers.Channels.lib.mongodb.internal.async.AsyncBatchCursor;
import net.zaiyers.Channels.lib.mongodb.internal.async.ErrorHandlingResultCallback;
import net.zaiyers.Channels.lib.mongodb.internal.async.SingleResultCallback;
import net.zaiyers.Channels.lib.mongodb.internal.binding.AsyncReadBinding;
import net.zaiyers.Channels.lib.mongodb.internal.binding.ReadBinding;
import net.zaiyers.Channels.lib.mongodb.internal.connection.QueryResult;
import net.zaiyers.Channels.lib.mongodb.internal.operation.AsyncQueryBatchCursor;
import net.zaiyers.Channels.lib.mongodb.internal.operation.AsyncReadOperation;
import net.zaiyers.Channels.lib.mongodb.internal.operation.BatchCursor;
import net.zaiyers.Channels.lib.mongodb.internal.operation.BsonDocumentWrapperHelper;
import net.zaiyers.Channels.lib.mongodb.internal.operation.CommandOperationHelper;
import net.zaiyers.Channels.lib.mongodb.internal.operation.CommandResultDocumentCodec;
import net.zaiyers.Channels.lib.mongodb.internal.operation.DocumentHelper;
import net.zaiyers.Channels.lib.mongodb.internal.operation.OperationHelper;
import net.zaiyers.Channels.lib.mongodb.internal.operation.QueryBatchCursor;
import net.zaiyers.Channels.lib.mongodb.internal.operation.ReadOperation;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

public class ListDatabasesOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private final Decoder<T> decoder;
    private boolean retryReads;
    private long maxTimeMS;
    private BsonDocument filter;
    private Boolean nameOnly;
    private Boolean authorizedDatabasesOnly;
    private BsonValue comment;

    public ListDatabasesOperation(Decoder<T> decoder) {
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public ListDatabasesOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public ListDatabasesOperation<T> filter(@Nullable BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public ListDatabasesOperation<T> nameOnly(Boolean nameOnly) {
        this.nameOnly = nameOnly;
        return this;
    }

    public ListDatabasesOperation<T> authorizedDatabasesOnly(Boolean authorizedDatabasesOnly) {
        this.authorizedDatabasesOnly = authorizedDatabasesOnly;
        return this;
    }

    public ListDatabasesOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    public Boolean getNameOnly() {
        return this.nameOnly;
    }

    public Boolean getAuthorizedDatabasesOnly() {
        return this.authorizedDatabasesOnly;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public ListDatabasesOperation<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        return CommandOperationHelper.executeRetryableRead(binding, "admin", this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, "databases"), this.transformer(), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        CommandOperationHelper.executeRetryableReadAsync(binding, "admin", this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, "databases"), this.asyncTransformer(), this.retryReads, ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, BatchCursor<T>> transformer() {
        return (result, source, connection) -> new QueryBatchCursor<T>(this.createQueryResult((BsonDocument)result, connection.getDescription()), 0, 0, this.decoder, this.comment, source);
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return (result, source, connection) -> new AsyncQueryBatchCursor<T>(this.createQueryResult((BsonDocument)result, connection.getDescription()), 0, 0, 0L, this.decoder, this.comment, source, connection, (BsonDocument)result);
    }

    private QueryResult<T> createQueryResult(BsonDocument result, ConnectionDescription description) {
        return new QueryResult(null, BsonDocumentWrapperHelper.toList(result, "databases"), 0L, description.getServerAddress());
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (serverDescription, connectionDescription) -> this.getCommand();
    }

    private BsonDocument getCommand() {
        BsonDocument command = new BsonDocument("listDatabases", new BsonInt32(1));
        if (this.maxTimeMS > 0L) {
            command.put("maxTimeMS", new BsonInt64(this.maxTimeMS));
        }
        if (this.filter != null) {
            command.put("filter", this.filter);
        }
        if (this.nameOnly != null) {
            command.put("nameOnly", new BsonBoolean(this.nameOnly));
        }
        if (this.authorizedDatabasesOnly != null) {
            command.put("authorizedDatabases", new BsonBoolean(this.authorizedDatabasesOnly));
        }
        DocumentHelper.putIfNotNull(command, "comment", this.comment);
        return command;
    }
}

