/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.operation;

import net.zaiyers.Channels.lib.bson.BsonBoolean;
import net.zaiyers.Channels.lib.bson.BsonDocument;
import net.zaiyers.Channels.lib.bson.BsonString;
import net.zaiyers.Channels.lib.mongodb.MongoNamespace;
import net.zaiyers.Channels.lib.mongodb.WriteConcern;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.internal.async.ErrorHandlingResultCallback;
import net.zaiyers.Channels.lib.mongodb.internal.async.SingleResultCallback;
import net.zaiyers.Channels.lib.mongodb.internal.binding.AsyncWriteBinding;
import net.zaiyers.Channels.lib.mongodb.internal.binding.WriteBinding;
import net.zaiyers.Channels.lib.mongodb.internal.operation.AsyncWriteOperation;
import net.zaiyers.Channels.lib.mongodb.internal.operation.CommandOperationHelper;
import net.zaiyers.Channels.lib.mongodb.internal.operation.OperationHelper;
import net.zaiyers.Channels.lib.mongodb.internal.operation.WriteConcernHelper;
import net.zaiyers.Channels.lib.mongodb.internal.operation.WriteOperation;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

public class RenameCollectionOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoNamespace originalNamespace;
    private final MongoNamespace newNamespace;
    private final WriteConcern writeConcern;
    private boolean dropTarget;

    public RenameCollectionOperation(MongoNamespace originalNamespace, MongoNamespace newNamespace) {
        this(originalNamespace, newNamespace, null);
    }

    public RenameCollectionOperation(MongoNamespace originalNamespace, MongoNamespace newNamespace, @Nullable WriteConcern writeConcern) {
        this.originalNamespace = Assertions.notNull("originalNamespace", originalNamespace);
        this.newNamespace = Assertions.notNull("newNamespace", newNamespace);
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean isDropTarget() {
        return this.dropTarget;
    }

    public RenameCollectionOperation dropTarget(boolean dropTarget) {
        this.dropTarget = dropTarget;
        return this;
    }

    @Override
    public Void execute(WriteBinding binding) {
        return OperationHelper.withConnection(binding, connection -> CommandOperationHelper.executeCommand(binding, "admin", this.getCommand(), connection, CommandOperationHelper.writeConcernErrorTransformer()));
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        OperationHelper.withAsyncConnection(binding, (connection, t) -> {
            SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
            if (t != null) {
                errHandlingCallback.onResult(null, t);
            } else {
                CommandOperationHelper.executeCommandAsync(binding, "admin", this.getCommand(), Assertions.assertNotNull(connection), CommandOperationHelper.writeConcernErrorWriteTransformer(), OperationHelper.releasingCallback(errHandlingCallback, connection));
            }
        });
    }

    private BsonDocument getCommand() {
        BsonDocument commandDocument = new BsonDocument("renameCollection", new BsonString(this.originalNamespace.getFullName())).append("to", new BsonString(this.newNamespace.getFullName())).append("dropTarget", BsonBoolean.valueOf(this.dropTarget));
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, commandDocument);
        return commandDocument;
    }
}

