/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.selector;

import java.util.Collections;
import java.util.List;
import net.zaiyers.Channels.lib.mongodb.ServerAddress;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.connection.ClusterDescription;
import net.zaiyers.Channels.lib.mongodb.connection.ServerDescription;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ClusterDescriptionHelper;
import net.zaiyers.Channels.lib.mongodb.selector.ServerSelector;

public class ServerAddressSelector
implements ServerSelector {
    private final ServerAddress serverAddress;

    public ServerAddressSelector(ServerAddress serverAddress) {
        this.serverAddress = Assertions.notNull("serverAddress", serverAddress);
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        ServerDescription serverDescription = ClusterDescriptionHelper.getByServerAddress(clusterDescription, this.serverAddress);
        if (serverDescription != null) {
            return Collections.singletonList(serverDescription);
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "ServerAddressSelector{serverAddress=" + this.serverAddress + '}';
    }
}

