/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.message;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.zaiyers.Channels.Channel;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.Chatter;
import net.zaiyers.Channels.lib.minedown.MineDown;
import net.zaiyers.Channels.lib.minedown.MineDownParser;
import net.zaiyers.Channels.lib.minedown.Replacer;
import net.zaiyers.Channels.message.AbstractMessage;

public class ChannelMessage
extends AbstractMessage {
    private Channel channel;
    private Chatter chatter;

    public ChannelMessage(Chatter chatter, Channel channel, String rawMessage) {
        this.chatter = chatter;
        this.channel = channel;
        this.rawMessage = Matcher.quoteReplacement(rawMessage);
    }

    public void processMessage() {
        if (this.processedMessage != null) {
            return;
        }
        Date date = new Date(this.getTime());
        SimpleDateFormat dateFormat = Channels.getConfig().getDateFormat();
        SimpleDateFormat timeFormat = Channels.getConfig().getTimeFormat();
        MineDown messageMd = new MineDown(this.rawMessage).urlHoverText(ChatColor.translateAlternateColorCodes((char)'&', (String)Channels.getInstance().getLanguage().getTranslation("chat.hover.open-url")));
        if (!this.chatter.hasPermission("channels.color")) {
            messageMd.disable(MineDownParser.Option.LEGACY_COLORS);
        }
        if (!this.chatter.hasPermission("channels.minedown.advanced")) {
            messageMd.disable(MineDownParser.Option.ADVANCED_FORMATTING);
        }
        if (!this.chatter.hasPermission("channels.minedown.simple")) {
            messageMd.disable(MineDownParser.Option.SIMPLE_FORMATTING);
        }
        this.processedMessage = new MineDown(new Replacer().replace("channelColor", this.channel.getColor().toString()).replaceIn(this.channel.getFormat())).replace("sender", this.chatter.getName(), "channelTag", this.channel.getTag(), "channelName", this.channel.getName(), "date", dateFormat.format(date), "time", timeFormat.format(date)).replace("prefix", MineDown.parse(this.chatter.getPrefix(), new String[0])).replace("suffix", MineDown.parse(this.chatter.getSuffix(), new String[0])).replace("msg", messageMd.toComponent()).toComponent();
    }

    @Override
    public BaseComponent[] getProcessedMessage() {
        if (this.processedMessage == null) {
            this.processMessage();
        }
        return super.getProcessedMessage();
    }

    @Override
    public void send(boolean hidden) {
        this.channel.send(this, hidden);
    }

    public Chatter getChatter() {
        return this.chatter;
    }

    @Override
    public CommandSender getSender() {
        return this.chatter.getPlayer();
    }

    public Channel getChannel() {
        return this.channel;
    }
}

