/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.bukkit;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.UUID;
import net.zaiyers.UUIDDB.bukkit.PlayerJoinListener;
import net.zaiyers.UUIDDB.core.CachedStorage;
import net.zaiyers.UUIDDB.core.Storage;
import net.zaiyers.UUIDDB.core.StorageException;
import net.zaiyers.UUIDDB.core.UUIDDBPlugin;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UUIDDB
extends JavaPlugin
implements UUIDDBPlugin {
    private Storage storage;

    public void onEnable() {
        String storageType = this.getConfig().getString("storage", "mongo");
        try {
            ConfigurationSection typeSection = this.getConfig().getConfigurationSection(storageType);
            this.storage = new CachedStorage((UUIDDBPlugin)this, typeSection != null ? new Storage.Config(storageType, typeSection.getValues(false), typeSection.getDefaultSection() != null ? typeSection.getValues(false) : null) : new Storage.Config(storageType, new HashMap()), this.getConfig().getInt("cachesize", 1000));
            if (this.getConfig().getBoolean("log")) {
                this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
            }
        }
        catch (UnknownHostException e) {
            this.getLogger().severe("Unknown host: " + this.getConfig().getString(storageType + ".host", "localhost"));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        catch (StorageException e) {
            e.printStackTrace();
            this.getLogger().severe("Failed to connect to mongodb");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        catch (ClassNotFoundException e) {
            this.getLogger().severe(e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.saveDefaultConfig();
    }

    public void onDisable() {
        this.getStorage().disable();
    }

    @Deprecated
    public static UUIDDB getInstance() {
        return (UUIDDB)Bukkit.getServer().getPluginManager().getPlugin("UUIDDB");
    }

    public Storage getStorage() {
        return this.storage;
    }

    @Deprecated
    public String getNameByUUID(UUID uuid) {
        return this.getNameByUUID(uuid.toString());
    }

    @Deprecated
    public String getNameByUUID(String uuid) {
        return this.getStorage().getNameByUUID(uuid);
    }

    @Deprecated
    public void insert(UUID uniqueId, String name) {
        this.getStorage().insert(uniqueId, name);
    }

    @Deprecated
    public boolean exists(UUID uuid, String name) {
        return this.getStorage().exists(uuid, name);
    }

    @Deprecated
    public String getUUIDByName(String name) {
        return this.getStorage().getUUIDByName(name);
    }

    @Deprecated
    public String getUUIDByName(String name, boolean casesensitive) {
        return this.getStorage().getUUIDByName(name, casesensitive);
    }
}

