/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.core;

import java.net.UnknownHostException;
import java.util.Date;
import java.util.UUID;
import java.util.regex.Pattern;
import net.zaiyers.UUIDDB.core.Storage;
import net.zaiyers.UUIDDB.core.UUIDDBPlugin;
import net.zaiyers.UUIDDB.lib.bson.Document;
import net.zaiyers.UUIDDB.lib.mongodb.ConnectionString;
import net.zaiyers.UUIDDB.lib.mongodb.MongoClientSettings;
import net.zaiyers.UUIDDB.lib.mongodb.MongoCredential;
import net.zaiyers.UUIDDB.lib.mongodb.MongoException;
import net.zaiyers.UUIDDB.lib.mongodb.ServerApi;
import net.zaiyers.UUIDDB.lib.mongodb.ServerApiVersion;
import net.zaiyers.UUIDDB.lib.mongodb.client.MongoClient;
import net.zaiyers.UUIDDB.lib.mongodb.client.MongoClients;
import net.zaiyers.UUIDDB.lib.mongodb.client.MongoCollection;
import net.zaiyers.UUIDDB.lib.mongodb.client.MongoCursor;
import net.zaiyers.UUIDDB.lib.mongodb.client.MongoDatabase;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.Filters;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.Sorts;

public class MongoStorage
implements Storage {
    private static final Pattern NAME_PATTERN = Pattern.compile("\\w{3,16}");
    private MongoClient mongo;
    private MongoCollection<Document> c;

    public MongoStorage(UUIDDBPlugin plugin, Storage.Config config) throws UnknownHostException, MongoException {
        String host = config.getString("host", "localhost");
        int port = config.getInt("port", 27017);
        String user = config.getString("user");
        String pass = config.getString("pass");
        String authdb = config.getString("authdb");
        String database = config.getString("db", "uuiddb");
        String collection = config.getString("collection", "uuiddb");
        if (user != null && !user.isEmpty() && (authdb == null || pass == null || authdb.isEmpty())) {
            throw new MongoException("Invalid configuration for mongoauth! To not use mongoauth leave the user empty!");
        }
        ServerApi serverApi = ServerApi.builder().version(ServerApiVersion.V1).build();
        MongoClientSettings.Builder settings = MongoClientSettings.builder().applyConnectionString(new ConnectionString("mongodb://" + host + ":" + port + "/")).serverApi(serverApi);
        if (user != null && !user.isEmpty()) {
            if (pass == null) {
                throw new MongoException("Invalid configuration for mongoauth! To not use mongoauth leave the user empty!");
            }
            settings.credential(MongoCredential.createPlainCredential(user, authdb, pass.toCharArray()));
        }
        this.mongo = MongoClients.create(settings.build());
        MongoDatabase db = this.mongo.getDatabase(database);
        this.c = db.getCollection(collection);
    }

    @Override
    public void disable() {
        if (this.mongo != null) {
            this.mongo.close();
        }
    }

    @Override
    public String getNameByUUID(UUID uuid) {
        return this.getNameByUUID(uuid.toString());
    }

    @Override
    public String getNameByUUID(String uuid) {
        MongoCursor cursor;
        if (uuid.length() == 32) {
            uuid = uuid.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5");
        }
        if ((cursor = this.c.find(Filters.eq("uuid", uuid)).sort(Sorts.descending("time")).cursor()).hasNext()) {
            return (String)((Document)cursor.next()).get("name");
        }
        return null;
    }

    @Override
    public void insert(UUID uniqueId, String name) {
        if (!MongoStorage.validate(name)) {
            throw new IllegalArgumentException("Name " + name + " is not valid! Tried to insert it for ID " + String.valueOf(uniqueId));
        }
        Document save = new Document();
        save.put("uuid", (Object)uniqueId.toString());
        save.put("name", (Object)name);
        save.put("time", (Object)new Date());
        this.c.insertOne(save);
    }

    @Override
    public boolean exists(UUID uuid, String name) {
        if (!MongoStorage.validate(name)) {
            return false;
        }
        MongoCursor cursor = this.c.find(Filters.eq("uuid", uuid.toString())).sort(Sorts.descending("time")).cursor();
        if (!cursor.hasNext()) {
            return false;
        }
        Document recent = (Document)cursor.next();
        return recent.get("name").equals(name);
    }

    @Override
    public String getUUIDByName(String name) {
        return this.getUUIDByName(name, true);
    }

    @Override
    public String getUUIDByName(String name, boolean casesensitive) {
        if (!MongoStorage.validate(name)) {
            return null;
        }
        Object value = casesensitive ? name : Pattern.compile("^" + name + "$", 2);
        MongoCursor cursor = this.c.find(Filters.eq("name", value)).sort(Sorts.descending("time")).cursor();
        if (!cursor.hasNext()) {
            return null;
        }
        return (String)((Document)cursor.next()).get("uuid");
    }

    private static boolean validate(String name) {
        return NAME_PATTERN.matcher(name).matches();
    }
}

