/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.core;

import java.util.Map;
import java.util.UUID;

public interface Storage {
    public void disable();

    public String getNameByUUID(UUID var1);

    public String getNameByUUID(String var1);

    public void insert(UUID var1, String var2);

    public boolean exists(UUID var1, String var2);

    public String getUUIDByName(String var1);

    public String getUUIDByName(String var1, boolean var2);

    public static class Config {
        private final String type;
        private final Map<String, Object> values;
        private final Config defaults;

        public Config(String storageType, Map<String, Object> values, Map<String, Object> defaults) {
            this(storageType, values, new Config(storageType, defaults));
        }

        public Config(String storageType, Map<String, Object> values, Config defaults) {
            this.type = storageType;
            this.values = values;
            this.defaults = defaults;
        }

        public Config(String storageType, Map<String, Object> values) {
            this.type = storageType;
            this.values = values;
            this.defaults = null;
        }

        public String getString(String key) {
            return this.getString(key, this.getDefaultString(key));
        }

        public String getString(String key, String def) {
            Object value;
            if (this.values != null && this.values.containsKey("key") && (value = this.values.get(key)) != null) {
                return value.toString();
            }
            return def != null ? def : "";
        }

        private String getDefaultString(String key) {
            return this.defaults != null ? this.defaults.getString(key) : "";
        }

        public int getInt(String key) {
            return this.getInt(key, this.getDefaultInt(key));
        }

        public int getInt(String key, int def) {
            if (this.values != null && this.values.containsKey("key")) {
                Object value = this.values.get(key);
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                try {
                    return Integer.valueOf(value.toString());
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            return def;
        }

        private int getDefaultInt(String key) {
            return this.defaults != null ? this.defaults.getInt(key) : 0;
        }

        public String getType() {
            return this.type;
        }
    }
}

