/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.bson.codecs;

import net.zaiyers.UUIDDB.lib.bson.BsonType;
import net.zaiyers.UUIDDB.lib.bson.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonTypeClassMap;
import net.zaiyers.UUIDDB.lib.bson.codecs.Codec;
import net.zaiyers.UUIDDB.lib.bson.codecs.configuration.CodecConfigurationException;
import net.zaiyers.UUIDDB.lib.bson.codecs.configuration.CodecRegistry;

public class BsonTypeCodecMap {
    private final BsonTypeClassMap bsonTypeClassMap;
    private final Codec<?>[] codecs = new Codec[256];

    public BsonTypeCodecMap(BsonTypeClassMap bsonTypeClassMap, CodecRegistry codecRegistry) {
        this.bsonTypeClassMap = Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap);
        Assertions.notNull("codecRegistry", codecRegistry);
        for (BsonType cur : bsonTypeClassMap.keys()) {
            Class<?> clazz = bsonTypeClassMap.get(cur);
            if (clazz == null) continue;
            try {
                this.codecs[cur.getValue()] = codecRegistry.get(clazz);
            }
            catch (CodecConfigurationException codecConfigurationException) {}
        }
    }

    public Codec<?> get(BsonType bsonType) {
        Codec<?> codec = this.codecs[bsonType.getValue()];
        if (codec == null) {
            Class<?> clazz = this.bsonTypeClassMap.get(bsonType);
            if (clazz == null) {
                throw new CodecConfigurationException(String.format("No class mapped for BSON type %s.", new Object[]{bsonType}));
            }
            throw new CodecConfigurationException(String.format("Can't find a codec for %s.", clazz));
        }
        return codec;
    }
}

