/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.bson.codecs;

import java.util.Objects;
import net.zaiyers.UUIDDB.lib.bson.Document;
import net.zaiyers.UUIDDB.lib.bson.Transformer;
import net.zaiyers.UUIDDB.lib.bson.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonTypeClassMap;
import net.zaiyers.UUIDDB.lib.bson.codecs.CodeWithScopeCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.Codec;
import net.zaiyers.UUIDDB.lib.bson.codecs.DocumentCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.configuration.CodecProvider;
import net.zaiyers.UUIDDB.lib.bson.codecs.configuration.CodecRegistry;
import net.zaiyers.UUIDDB.lib.bson.types.CodeWithScope;

public class DocumentCodecProvider
implements CodecProvider {
    private final BsonTypeClassMap bsonTypeClassMap;
    private final Transformer valueTransformer;

    public DocumentCodecProvider() {
        this(BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP);
    }

    public DocumentCodecProvider(Transformer valueTransformer) {
        this(BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP, valueTransformer);
    }

    public DocumentCodecProvider(BsonTypeClassMap bsonTypeClassMap) {
        this(bsonTypeClassMap, null);
    }

    public DocumentCodecProvider(BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer) {
        this.bsonTypeClassMap = Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap);
        this.valueTransformer = valueTransformer;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (clazz == CodeWithScope.class) {
            return new CodeWithScopeCodec(registry.get(Document.class));
        }
        if (clazz == Document.class) {
            return new DocumentCodec(registry, this.bsonTypeClassMap, this.valueTransformer);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentCodecProvider that = (DocumentCodecProvider)o;
        if (!this.bsonTypeClassMap.equals(that.bsonTypeClassMap)) {
            return false;
        }
        return Objects.equals(this.valueTransformer, that.valueTransformer);
    }

    public int hashCode() {
        int result = this.bsonTypeClassMap.hashCode();
        result = 31 * result + (this.valueTransformer != null ? this.valueTransformer.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DocumentCodecProvider{}";
    }
}

