/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb;

import java.util.Date;
import java.util.List;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonTypeClassMap;
import net.zaiyers.UUIDDB.lib.bson.codecs.Codec;
import net.zaiyers.UUIDDB.lib.bson.codecs.DateCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.configuration.CodecProvider;
import net.zaiyers.UUIDDB.lib.bson.codecs.configuration.CodecRegistry;
import net.zaiyers.UUIDDB.lib.bson.types.BSONTimestamp;
import net.zaiyers.UUIDDB.lib.mongodb.BSONTimestampCodec;
import net.zaiyers.UUIDDB.lib.mongodb.DBObject;
import net.zaiyers.UUIDDB.lib.mongodb.DBObjectCodec;
import net.zaiyers.UUIDDB.lib.mongodb.assertions.Assertions;

public class DBObjectCodecProvider
implements CodecProvider {
    private final BsonTypeClassMap bsonTypeClassMap;

    public DBObjectCodecProvider() {
        this(DBObjectCodec.getDefaultBsonTypeClassMap());
    }

    public DBObjectCodecProvider(BsonTypeClassMap bsonTypeClassMap) {
        this.bsonTypeClassMap = Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (clazz == BSONTimestamp.class) {
            return new BSONTimestampCodec();
        }
        if (DBObject.class.isAssignableFrom(clazz) && !List.class.isAssignableFrom(clazz)) {
            return new DBObjectCodec(registry, this.bsonTypeClassMap);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new DateCodec();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "DBObjectCodecProvider{}";
    }
}

