/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.client.internal;

import net.zaiyers.UUIDDB.lib.bson.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.mongodb.ReadConcern;
import net.zaiyers.UUIDDB.lib.mongodb.ReadPreference;
import net.zaiyers.UUIDDB.lib.mongodb.RequestContext;
import net.zaiyers.UUIDDB.lib.mongodb.ServerApi;
import net.zaiyers.UUIDDB.lib.mongodb.client.ClientSession;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ClusterType;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ServerDescription;
import net.zaiyers.UUIDDB.lib.mongodb.internal.binding.AbstractReferenceCounted;
import net.zaiyers.UUIDDB.lib.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import net.zaiyers.UUIDDB.lib.mongodb.internal.binding.ConnectionSource;
import net.zaiyers.UUIDDB.lib.mongodb.internal.binding.ReadWriteBinding;
import net.zaiyers.UUIDDB.lib.mongodb.internal.binding.TransactionContext;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.Connection;
import net.zaiyers.UUIDDB.lib.mongodb.internal.session.ClientSessionContext;
import net.zaiyers.UUIDDB.lib.mongodb.internal.session.SessionContext;
import net.zaiyers.UUIDDB.lib.mongodb.lang.Nullable;

public class ClientSessionBinding
extends AbstractReferenceCounted
implements ReadWriteBinding {
    private final ClusterAwareReadWriteBinding wrapped;
    private final ClientSession session;
    private final boolean ownsSession;
    private final ClientSessionContext sessionContext;

    public ClientSessionBinding(ClientSession session, boolean ownsSession, ClusterAwareReadWriteBinding wrapped) {
        this.wrapped = wrapped;
        wrapped.retain();
        this.session = Assertions.notNull("session", session);
        this.ownsSession = ownsSession;
        this.sessionContext = new SyncClientSessionContext(session);
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public ClientSessionBinding retain() {
        super.retain();
        return this;
    }

    @Override
    public int release() {
        int count = super.release();
        if (count == 0) {
            this.wrapped.release();
            if (this.ownsSession) {
                this.session.close();
            }
        }
        return count;
    }

    @Override
    public ConnectionSource getReadConnectionSource() {
        if (this.isConnectionSourcePinningRequired()) {
            return new SessionBindingConnectionSource(this.getPinnedConnectionSource(true));
        }
        return new SessionBindingConnectionSource(this.wrapped.getReadConnectionSource());
    }

    @Override
    public ConnectionSource getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference) {
        if (this.isConnectionSourcePinningRequired()) {
            return new SessionBindingConnectionSource(this.getPinnedConnectionSource(true));
        }
        return new SessionBindingConnectionSource(this.wrapped.getReadConnectionSource(minWireVersion, fallbackReadPreference));
    }

    @Override
    public ConnectionSource getWriteConnectionSource() {
        if (this.isConnectionSourcePinningRequired()) {
            return new SessionBindingConnectionSource(this.getPinnedConnectionSource(false));
        }
        return new SessionBindingConnectionSource(this.wrapped.getWriteConnectionSource());
    }

    @Override
    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    @Nullable
    public ServerApi getServerApi() {
        return this.wrapped.getServerApi();
    }

    @Override
    public RequestContext getRequestContext() {
        return this.wrapped.getRequestContext();
    }

    private boolean isConnectionSourcePinningRequired() {
        ClusterType clusterType = this.wrapped.getCluster().getDescription().getType();
        return this.session.hasActiveTransaction() && (clusterType == ClusterType.SHARDED || clusterType == ClusterType.LOAD_BALANCED);
    }

    private ConnectionSource getPinnedConnectionSource(boolean isRead) {
        ConnectionSource source;
        Object transactionContext = TransactionContext.get(this.session);
        if (transactionContext == null) {
            source = isRead ? this.wrapped.getReadConnectionSource() : this.wrapped.getWriteConnectionSource();
            transactionContext = new TransactionContext(this.wrapped.getCluster().getDescription().getType());
            this.session.setTransactionContext(source.getServerDescription().getAddress(), transactionContext);
            ((TransactionContext)transactionContext).release();
        } else {
            source = this.wrapped.getConnectionSource(Assertions.assertNotNull(this.session.getPinnedServerAddress()));
        }
        return source;
    }

    private final class SyncClientSessionContext
    extends ClientSessionContext {
        private final ClientSession clientSession;

        SyncClientSessionContext(ClientSession clientSession) {
            super(clientSession);
            this.clientSession = clientSession;
        }

        @Override
        public boolean isImplicitSession() {
            return ClientSessionBinding.this.ownsSession;
        }

        @Override
        public boolean notifyMessageSent() {
            return this.clientSession.notifyMessageSent();
        }

        @Override
        public boolean hasActiveTransaction() {
            return this.clientSession.hasActiveTransaction();
        }

        @Override
        public ReadConcern getReadConcern() {
            if (this.clientSession.hasActiveTransaction()) {
                return Assertions.assertNotNull(this.clientSession.getTransactionOptions().getReadConcern());
            }
            if (this.isSnapshot()) {
                return ReadConcern.SNAPSHOT;
            }
            return ClientSessionBinding.this.wrapped.getSessionContext().getReadConcern();
        }
    }

    private class SessionBindingConnectionSource
    implements ConnectionSource {
        private ConnectionSource wrapped;

        SessionBindingConnectionSource(ConnectionSource wrapped) {
            this.wrapped = wrapped;
            ClientSessionBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        @Override
        public SessionContext getSessionContext() {
            return ClientSessionBinding.this.sessionContext;
        }

        @Override
        public ServerApi getServerApi() {
            return this.wrapped.getServerApi();
        }

        @Override
        public RequestContext getRequestContext() {
            return this.wrapped.getRequestContext();
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.wrapped.getReadPreference();
        }

        @Override
        public Connection getConnection() {
            Connection transactionContext = TransactionContext.get(ClientSessionBinding.this.session);
            if (transactionContext != null && ((TransactionContext)((Object)transactionContext)).isConnectionPinningRequired()) {
                Connection pinnedConnection = (Connection)((TransactionContext)((Object)transactionContext)).getPinnedConnection();
                if (pinnedConnection == null) {
                    Connection connection = this.wrapped.getConnection();
                    ((TransactionContext)((Object)transactionContext)).pinConnection((Connection)connection, Connection::markAsPinned);
                    return connection;
                }
                return pinnedConnection.retain();
            }
            return this.wrapped.getConnection();
        }

        @Override
        public ConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public int release() {
            int count = this.wrapped.release();
            if (count == 0) {
                ClientSessionBinding.this.release();
            }
            return count;
        }
    }
}

