/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.client.internal;

import net.zaiyers.UUIDDB.lib.mongodb.ReadPreference;
import net.zaiyers.UUIDDB.lib.mongodb.RequestContext;
import net.zaiyers.UUIDDB.lib.mongodb.ServerAddress;
import net.zaiyers.UUIDDB.lib.mongodb.ServerApi;
import net.zaiyers.UUIDDB.lib.mongodb.client.internal.Crypt;
import net.zaiyers.UUIDDB.lib.mongodb.client.internal.CryptConnection;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ServerDescription;
import net.zaiyers.UUIDDB.lib.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import net.zaiyers.UUIDDB.lib.mongodb.internal.binding.ConnectionSource;
import net.zaiyers.UUIDDB.lib.mongodb.internal.binding.ReadWriteBinding;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.Cluster;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.Connection;
import net.zaiyers.UUIDDB.lib.mongodb.internal.session.SessionContext;
import net.zaiyers.UUIDDB.lib.mongodb.lang.Nullable;

class CryptBinding
implements ClusterAwareReadWriteBinding {
    private final ClusterAwareReadWriteBinding wrapped;
    private final Crypt crypt;

    CryptBinding(ClusterAwareReadWriteBinding wrapped, Crypt crypt) {
        this.crypt = crypt;
        this.wrapped = wrapped;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public ConnectionSource getReadConnectionSource() {
        return new CryptConnectionSource(this.wrapped.getReadConnectionSource());
    }

    @Override
    public ConnectionSource getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference) {
        return new CryptConnectionSource(this.wrapped.getReadConnectionSource(minWireVersion, fallbackReadPreference));
    }

    @Override
    public ConnectionSource getWriteConnectionSource() {
        return new CryptConnectionSource(this.wrapped.getWriteConnectionSource());
    }

    @Override
    public ConnectionSource getConnectionSource(ServerAddress serverAddress) {
        return new CryptConnectionSource(this.wrapped.getConnectionSource(serverAddress));
    }

    @Override
    public SessionContext getSessionContext() {
        return this.wrapped.getSessionContext();
    }

    @Override
    @Nullable
    public ServerApi getServerApi() {
        return this.wrapped.getServerApi();
    }

    @Override
    public RequestContext getRequestContext() {
        return this.wrapped.getRequestContext();
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public ReadWriteBinding retain() {
        this.wrapped.retain();
        return this;
    }

    @Override
    public int release() {
        return this.wrapped.release();
    }

    @Override
    public Cluster getCluster() {
        return this.wrapped.getCluster();
    }

    private class CryptConnectionSource
    implements ConnectionSource {
        private final ConnectionSource wrapped;

        CryptConnectionSource(ConnectionSource wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        @Override
        public SessionContext getSessionContext() {
            return this.wrapped.getSessionContext();
        }

        @Override
        public ServerApi getServerApi() {
            return this.wrapped.getServerApi();
        }

        @Override
        public RequestContext getRequestContext() {
            return this.wrapped.getRequestContext();
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.wrapped.getReadPreference();
        }

        @Override
        public Connection getConnection() {
            return new CryptConnection(this.wrapped.getConnection(), CryptBinding.this.crypt);
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public ConnectionSource retain() {
            this.wrapped.retain();
            return this;
        }

        @Override
        public int release() {
            return this.wrapped.release();
        }
    }
}

