/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.client.model.changestream;

import java.util.Objects;
import net.zaiyers.UUIDDB.lib.bson.codecs.pojo.annotations.BsonCreator;
import net.zaiyers.UUIDDB.lib.bson.codecs.pojo.annotations.BsonProperty;
import net.zaiyers.UUIDDB.lib.mongodb.assertions.Assertions;

public final class TruncatedArray {
    private final String field;
    private final int newSize;

    @BsonCreator
    public TruncatedArray(@BsonProperty(value="field") String field, @BsonProperty(value="newSize") int newSize) {
        this.field = Assertions.notNull("field", field);
        Assertions.isTrueArgument("newSize >= 0", newSize >= 0);
        this.newSize = newSize;
    }

    public String getField() {
        return this.field;
    }

    public int getNewSize() {
        return this.newSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TruncatedArray that = (TruncatedArray)o;
        return this.newSize == that.newSize && this.field.equals(that.field);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.newSize);
    }

    public String toString() {
        return "TruncatedArray{field=" + this.field + ", newSize=" + this.newSize + '}';
    }
}

