/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.client.model.search;

import net.zaiyers.UUIDDB.lib.bson.BsonDocument;
import net.zaiyers.UUIDDB.lib.bson.BsonString;
import net.zaiyers.UUIDDB.lib.bson.BsonValue;
import net.zaiyers.UUIDDB.lib.bson.conversions.Bson;
import net.zaiyers.UUIDDB.lib.mongodb.annotations.Beta;
import net.zaiyers.UUIDDB.lib.mongodb.annotations.Evolving;
import net.zaiyers.UUIDDB.lib.mongodb.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.search.FieldSearchPath;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.search.SearchConstructibleBson;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.search.WildcardSearchPath;

@Evolving
@Beta(value={Beta.Reason.CLIENT})
public interface SearchPath
extends Bson {
    public static FieldSearchPath fieldPath(String path) {
        Assertions.notNull("path", path);
        Assertions.isTrueArgument("path must not contain '*'", !path.contains("*"));
        return new SearchConstructibleBson(new BsonDocument("value", new BsonString(path)));
    }

    public static WildcardSearchPath wildcardPath(String wildcardPath) {
        Assertions.notNull("wildcardPath", wildcardPath);
        Assertions.isTrueArgument("wildcardPath must contain '*'", wildcardPath.contains("*"));
        Assertions.isTrueArgument("wildcardPath must not contain '**'", !wildcardPath.contains("**"));
        return new SearchConstructibleBson(new BsonDocument("wildcard", new BsonString(wildcardPath)));
    }

    default public BsonValue toBsonValue() {
        BsonDocument doc = this.toBsonDocument();
        if (doc.size() > 1) {
            return doc;
        }
        BsonString value = doc.getString("value", null);
        if (value != null) {
            return value;
        }
        return doc;
    }
}

