/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.binding;

import net.zaiyers.UUIDDB.lib.mongodb.ReadConcern;
import net.zaiyers.UUIDDB.lib.mongodb.ReadPreference;
import net.zaiyers.UUIDDB.lib.mongodb.RequestContext;
import net.zaiyers.UUIDDB.lib.mongodb.ServerAddress;
import net.zaiyers.UUIDDB.lib.mongodb.ServerApi;
import net.zaiyers.UUIDDB.lib.mongodb.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ClusterConnectionMode;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ServerDescription;
import net.zaiyers.UUIDDB.lib.mongodb.internal.binding.AbstractReferenceCounted;
import net.zaiyers.UUIDDB.lib.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import net.zaiyers.UUIDDB.lib.mongodb.internal.binding.ConnectionSource;
import net.zaiyers.UUIDDB.lib.mongodb.internal.binding.ReadWriteBinding;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.Cluster;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.Connection;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.ReadConcernAwareNoOpSessionContext;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.Server;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.ServerTuple;
import net.zaiyers.UUIDDB.lib.mongodb.internal.selector.ReadPreferenceServerSelector;
import net.zaiyers.UUIDDB.lib.mongodb.internal.selector.ReadPreferenceWithFallbackServerSelector;
import net.zaiyers.UUIDDB.lib.mongodb.internal.selector.ServerAddressSelector;
import net.zaiyers.UUIDDB.lib.mongodb.internal.selector.WritableServerSelector;
import net.zaiyers.UUIDDB.lib.mongodb.internal.session.SessionContext;
import net.zaiyers.UUIDDB.lib.mongodb.lang.Nullable;

public class ClusterBinding
extends AbstractReferenceCounted
implements ClusterAwareReadWriteBinding {
    private final Cluster cluster;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    @Nullable
    private final ServerApi serverApi;
    private final RequestContext requestContext;

    public ClusterBinding(Cluster cluster, ReadPreference readPreference, ReadConcern readConcern, @Nullable ServerApi serverApi, RequestContext requestContext) {
        this.cluster = Assertions.notNull("cluster", cluster);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.serverApi = serverApi;
        this.requestContext = Assertions.notNull("requestContext", requestContext);
    }

    @Override
    public Cluster getCluster() {
        return this.cluster;
    }

    @Override
    public ReadWriteBinding retain() {
        super.retain();
        return this;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public SessionContext getSessionContext() {
        return new ReadConcernAwareNoOpSessionContext(this.readConcern);
    }

    @Override
    @Nullable
    public ServerApi getServerApi() {
        return this.serverApi;
    }

    @Override
    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    @Override
    public ConnectionSource getReadConnectionSource() {
        return new ClusterBindingConnectionSource(this.cluster.selectServer(new ReadPreferenceServerSelector(this.readPreference)), this.readPreference);
    }

    @Override
    public ConnectionSource getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference) {
        if (this.cluster.getSettings().getMode() == ClusterConnectionMode.LOAD_BALANCED) {
            return this.getReadConnectionSource();
        }
        ReadPreferenceWithFallbackServerSelector readPreferenceWithFallbackServerSelector = new ReadPreferenceWithFallbackServerSelector(this.readPreference, minWireVersion, fallbackReadPreference);
        ServerTuple serverTuple = this.cluster.selectServer(readPreferenceWithFallbackServerSelector);
        return new ClusterBindingConnectionSource(serverTuple, readPreferenceWithFallbackServerSelector.getAppliedReadPreference());
    }

    @Override
    public ConnectionSource getWriteConnectionSource() {
        return new ClusterBindingConnectionSource(this.cluster.selectServer(new WritableServerSelector()), this.readPreference);
    }

    @Override
    public ConnectionSource getConnectionSource(ServerAddress serverAddress) {
        return new ClusterBindingConnectionSource(this.cluster.selectServer(new ServerAddressSelector(serverAddress)), this.readPreference);
    }

    private final class ClusterBindingConnectionSource
    extends AbstractReferenceCounted
    implements ConnectionSource {
        private final Server server;
        private final ServerDescription serverDescription;
        private final ReadPreference appliedReadPreference;

        private ClusterBindingConnectionSource(ServerTuple serverTuple, ReadPreference appliedReadPreference) {
            this.server = serverTuple.getServer();
            this.serverDescription = serverTuple.getServerDescription();
            this.appliedReadPreference = appliedReadPreference;
            ClusterBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.serverDescription;
        }

        @Override
        public SessionContext getSessionContext() {
            return new ReadConcernAwareNoOpSessionContext(ClusterBinding.this.readConcern);
        }

        @Override
        public ServerApi getServerApi() {
            return ClusterBinding.this.serverApi;
        }

        @Override
        public RequestContext getRequestContext() {
            return ClusterBinding.this.requestContext;
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.appliedReadPreference;
        }

        @Override
        public Connection getConnection() {
            return this.server.getConnection();
        }

        @Override
        public ConnectionSource retain() {
            super.retain();
            ClusterBinding.this.retain();
            return this;
        }

        @Override
        public int release() {
            int count = super.release();
            ClusterBinding.this.release();
            return count;
        }
    }
}

