/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.connection;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import net.zaiyers.UUIDDB.lib.mongodb.annotations.ThreadSafe;
import net.zaiyers.UUIDDB.lib.mongodb.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ClusterId;
import net.zaiyers.UUIDDB.lib.mongodb.event.ClusterClosedEvent;
import net.zaiyers.UUIDDB.lib.mongodb.event.ClusterDescriptionChangedEvent;
import net.zaiyers.UUIDDB.lib.mongodb.event.ClusterListener;
import net.zaiyers.UUIDDB.lib.mongodb.event.ClusterOpeningEvent;
import net.zaiyers.UUIDDB.lib.mongodb.event.ServerClosedEvent;
import net.zaiyers.UUIDDB.lib.mongodb.event.ServerDescriptionChangedEvent;
import net.zaiyers.UUIDDB.lib.mongodb.event.ServerHeartbeatFailedEvent;
import net.zaiyers.UUIDDB.lib.mongodb.event.ServerHeartbeatStartedEvent;
import net.zaiyers.UUIDDB.lib.mongodb.event.ServerHeartbeatSucceededEvent;
import net.zaiyers.UUIDDB.lib.mongodb.event.ServerListener;
import net.zaiyers.UUIDDB.lib.mongodb.event.ServerMonitorListener;
import net.zaiyers.UUIDDB.lib.mongodb.event.ServerOpeningEvent;

@ThreadSafe
final class AsynchronousClusterEventListener
implements ClusterListener,
ServerListener,
ServerMonitorListener {
    private final BlockingQueue<Supplier<Boolean>> eventPublishers = new LinkedBlockingQueue<Supplier<Boolean>>();
    private final ClusterListener clusterListener;
    private final ServerListener serverListener;
    private final ServerMonitorListener serverMonitorListener;
    private final Thread publishingThread;

    static AsynchronousClusterEventListener startNew(ClusterId clusterId, ClusterListener clusterListener, ServerListener serverListener, ServerMonitorListener serverMonitorListener) {
        AsynchronousClusterEventListener result = new AsynchronousClusterEventListener(clusterId, clusterListener, serverListener, serverMonitorListener);
        result.publishingThread.start();
        return result;
    }

    private AsynchronousClusterEventListener(ClusterId clusterId, ClusterListener clusterListener, ServerListener serverListener, ServerMonitorListener serverMonitorListener) {
        this.clusterListener = Assertions.notNull("clusterListener", clusterListener);
        this.serverListener = Assertions.notNull("serverListener", serverListener);
        this.serverMonitorListener = Assertions.notNull("serverMonitorListener", serverMonitorListener);
        this.publishingThread = new Thread(this::publishEvents, "cluster-event-publisher-" + clusterId.getValue());
        this.publishingThread.setDaemon(true);
    }

    Thread getPublishingThread() {
        return this.publishingThread;
    }

    @Override
    public void clusterOpening(ClusterOpeningEvent event) {
        this.addClusterEventInvocation(clusterListener -> clusterListener.clusterOpening(event), false);
    }

    @Override
    public void clusterClosed(ClusterClosedEvent event) {
        this.addClusterEventInvocation(clusterListener -> clusterListener.clusterClosed(event), true);
    }

    @Override
    public void clusterDescriptionChanged(ClusterDescriptionChangedEvent event) {
        this.addClusterEventInvocation(clusterListener -> clusterListener.clusterDescriptionChanged(event), false);
    }

    @Override
    public void serverOpening(ServerOpeningEvent event) {
        this.addServerEventInvocation(serverListener -> serverListener.serverOpening(event));
    }

    @Override
    public void serverClosed(ServerClosedEvent event) {
        this.addServerEventInvocation(serverListener -> serverListener.serverClosed(event));
    }

    @Override
    public void serverDescriptionChanged(ServerDescriptionChangedEvent event) {
        this.addServerEventInvocation(serverListener -> serverListener.serverDescriptionChanged(event));
    }

    @Override
    public void serverHearbeatStarted(ServerHeartbeatStartedEvent event) {
        this.addServerMonitorEventInvocation(serverMonitorListener -> serverMonitorListener.serverHearbeatStarted(event));
    }

    @Override
    public void serverHeartbeatSucceeded(ServerHeartbeatSucceededEvent event) {
        this.addServerMonitorEventInvocation(serverMonitorListener -> serverMonitorListener.serverHeartbeatSucceeded(event));
    }

    @Override
    public void serverHeartbeatFailed(ServerHeartbeatFailedEvent event) {
        this.addServerMonitorEventInvocation(serverMonitorListener -> serverMonitorListener.serverHeartbeatFailed(event));
    }

    private void addClusterEventInvocation(VoidFunction<ClusterListener> eventPublisher, boolean isLastEvent) {
        this.addEvent(() -> {
            eventPublisher.apply(this.clusterListener);
            return isLastEvent;
        });
    }

    private void addServerEventInvocation(VoidFunction<ServerListener> eventPublisher) {
        this.addEvent(() -> {
            eventPublisher.apply(this.serverListener);
            return false;
        });
    }

    private void addServerMonitorEventInvocation(VoidFunction<ServerMonitorListener> eventPublisher) {
        this.addEvent(() -> {
            eventPublisher.apply(this.serverMonitorListener);
            return false;
        });
    }

    private void addEvent(Supplier<Boolean> supplier) {
        if (!this.publishingThread.isAlive()) {
            return;
        }
        this.eventPublishers.add(supplier);
    }

    private void publishEvents() {
        while (true) {
            try {
                Supplier<Boolean> eventPublisher;
                boolean isLastEvent;
                while (!(isLastEvent = (eventPublisher = this.eventPublishers.take()).get().booleanValue())) {
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    @FunctionalInterface
    private static interface VoidFunction<T> {
        public void apply(T var1);
    }
}

