/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.connection;

import java.util.Locale;
import net.zaiyers.UUIDDB.lib.bson.BsonDocument;
import net.zaiyers.UUIDDB.lib.bson.BsonValue;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonDocumentCodec;
import net.zaiyers.UUIDDB.lib.mongodb.MongoNamespace;
import net.zaiyers.UUIDDB.lib.mongodb.MongoServerException;
import net.zaiyers.UUIDDB.lib.mongodb.ReadPreference;
import net.zaiyers.UUIDDB.lib.mongodb.ServerApi;
import net.zaiyers.UUIDDB.lib.mongodb.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ClusterConnectionMode;
import net.zaiyers.UUIDDB.lib.mongodb.internal.IgnorableRequestContext;
import net.zaiyers.UUIDDB.lib.mongodb.internal.async.SingleResultCallback;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.ClusterClock;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.ClusterClockAdvancingSessionContext;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.CommandMessage;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.InternalConnection;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.MessageSettings;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.NoOpSessionContext;
import net.zaiyers.UUIDDB.lib.mongodb.internal.session.SessionContext;
import net.zaiyers.UUIDDB.lib.mongodb.internal.validator.NoOpFieldNameValidator;
import net.zaiyers.UUIDDB.lib.mongodb.lang.Nullable;

public final class CommandHelper {
    static final String HELLO = "hello";
    static final String LEGACY_HELLO = "isMaster";
    static final String LEGACY_HELLO_LOWER = "isMaster".toLowerCase(Locale.ROOT);

    static BsonDocument executeCommand(String database, BsonDocument command, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection) {
        return CommandHelper.sendAndReceive(database, command, null, clusterConnectionMode, serverApi, internalConnection);
    }

    public static BsonDocument executeCommand(String database, BsonDocument command, ClusterClock clusterClock, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection) {
        return CommandHelper.sendAndReceive(database, command, clusterClock, clusterConnectionMode, serverApi, internalConnection);
    }

    static BsonDocument executeCommandWithoutCheckingForFailure(String database, BsonDocument command, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection) {
        try {
            return CommandHelper.sendAndReceive(database, command, null, clusterConnectionMode, serverApi, internalConnection);
        }
        catch (MongoServerException e) {
            return new BsonDocument();
        }
    }

    static void executeCommandAsync(String database, BsonDocument command, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection, SingleResultCallback<BsonDocument> callback) {
        internalConnection.sendAndReceiveAsync(CommandHelper.getCommandMessage(database, command, internalConnection, clusterConnectionMode, serverApi), new BsonDocumentCodec(), NoOpSessionContext.INSTANCE, IgnorableRequestContext.INSTANCE, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult((BsonDocument)result, null);
            }
        });
    }

    static boolean isCommandOk(BsonDocument response) {
        if (!response.containsKey("ok")) {
            return false;
        }
        BsonValue okValue = response.get("ok");
        if (okValue.isBoolean()) {
            return okValue.asBoolean().getValue();
        }
        if (okValue.isNumber()) {
            return okValue.asNumber().intValue() == 1;
        }
        return false;
    }

    private static BsonDocument sendAndReceive(String database, BsonDocument command, @Nullable ClusterClock clusterClock, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection) {
        SessionContext sessionContext = clusterClock == null ? NoOpSessionContext.INSTANCE : new ClusterClockAdvancingSessionContext(NoOpSessionContext.INSTANCE, clusterClock);
        return Assertions.assertNotNull(internalConnection.sendAndReceive(CommandHelper.getCommandMessage(database, command, internalConnection, clusterConnectionMode, serverApi), new BsonDocumentCodec(), sessionContext, IgnorableRequestContext.INSTANCE));
    }

    private static CommandMessage getCommandMessage(String database, BsonDocument command, InternalConnection internalConnection, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        return new CommandMessage(new MongoNamespace(database, "$cmd"), command, new NoOpFieldNameValidator(), ReadPreference.primary(), MessageSettings.builder().maxWireVersion(internalConnection.getDescription().getMaxWireVersion()).serverType(internalConnection.getDescription().getServerType()).build(), clusterConnectionMode, serverApi);
    }

    private CommandHelper() {
    }
}

