/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.connection;

import java.util.List;
import net.zaiyers.UUIDDB.lib.bson.BsonBinaryWriter;
import net.zaiyers.UUIDDB.lib.bson.BsonElement;
import net.zaiyers.UUIDDB.lib.bson.BsonReader;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.BsonWriterHelper;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.LevelCountingBsonWriter;

public class ElementExtendingBsonWriter
extends LevelCountingBsonWriter {
    private final BsonBinaryWriter writer;
    private final List<BsonElement> extraElements;

    public ElementExtendingBsonWriter(BsonBinaryWriter writer, List<BsonElement> extraElements) {
        super(writer);
        this.writer = writer;
        this.extraElements = extraElements;
    }

    @Override
    public void writeEndDocument() {
        if (this.getCurrentLevel() == 0) {
            BsonWriterHelper.writeElements(this.writer, this.extraElements);
        }
        super.writeEndDocument();
    }

    @Override
    public void pipe(BsonReader reader) {
        if (this.getCurrentLevel() == -1) {
            this.writer.pipe(reader, this.extraElements);
        } else {
            this.writer.pipe(reader);
        }
    }
}

