/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.connection;

import net.zaiyers.UUIDDB.lib.mongodb.assertions.Assertions;

class ExponentiallyWeightedMovingAverage {
    private final double alpha;
    private long average = -1L;

    ExponentiallyWeightedMovingAverage(double alpha) {
        Assertions.isTrueArgument("alpha >= 0.0 and <= 1.0", alpha >= 0.0 && alpha <= 1.0);
        this.alpha = alpha;
    }

    synchronized void reset() {
        this.average = -1L;
    }

    synchronized long addSample(long sample) {
        this.average = this.average == -1L ? sample : (long)(this.alpha * (double)sample + (1.0 - this.alpha) * (double)this.average);
        return this.average;
    }

    synchronized long getAverage() {
        return this.average == -1L ? 0L : this.average;
    }
}

