/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.connection;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import net.zaiyers.UUIDDB.lib.mongodb.AuthenticationMechanism;
import net.zaiyers.UUIDDB.lib.mongodb.KerberosSubjectProvider;
import net.zaiyers.UUIDDB.lib.mongodb.MongoCredential;
import net.zaiyers.UUIDDB.lib.mongodb.MongoException;
import net.zaiyers.UUIDDB.lib.mongodb.MongoSecurityException;
import net.zaiyers.UUIDDB.lib.mongodb.ServerAddress;
import net.zaiyers.UUIDDB.lib.mongodb.ServerApi;
import net.zaiyers.UUIDDB.lib.mongodb.SubjectProvider;
import net.zaiyers.UUIDDB.lib.mongodb.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ClusterConnectionMode;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.MongoCredentialWithCache;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.SaslAuthenticator;
import net.zaiyers.UUIDDB.lib.mongodb.lang.NonNull;
import net.zaiyers.UUIDDB.lib.mongodb.lang.Nullable;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

class GSSAPIAuthenticator
extends SaslAuthenticator {
    private static final String GSSAPI_MECHANISM_NAME = "GSSAPI";
    private static final String GSSAPI_OID = "1.2.840.113554.1.2.2";
    private static final String SERVICE_NAME_DEFAULT_VALUE = "mongodb";
    private static final Boolean CANONICALIZE_HOST_NAME_DEFAULT_VALUE = false;

    GSSAPIAuthenticator(MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(credential, clusterConnectionMode, serverApi);
        if (this.getMongoCredential().getAuthenticationMechanism() != AuthenticationMechanism.GSSAPI) {
            throw new MongoException("Incorrect mechanism: " + this.getMongoCredential().getMechanism());
        }
    }

    @Override
    public String getMechanismName() {
        return GSSAPI_MECHANISM_NAME;
    }

    @Override
    protected SaslClient createSaslClient(ServerAddress serverAddress) {
        MongoCredential credential = this.getMongoCredential();
        try {
            SaslClient saslClient;
            HashMap<String, Object> saslClientProperties = credential.getMechanismProperty("JAVA_SASL_CLIENT_PROPERTIES", null);
            if (saslClientProperties == null) {
                saslClientProperties = new HashMap<String, Object>();
                saslClientProperties.put("javax.security.sasl.maxbuffer", "0");
                saslClientProperties.put("javax.security.sasl.credentials", this.getGSSCredential(Assertions.assertNotNull(credential.getUserName())));
            }
            if ((saslClient = Sasl.createSaslClient(new String[]{AuthenticationMechanism.GSSAPI.getMechanismName()}, credential.getUserName(), credential.getMechanismProperty("SERVICE_NAME", SERVICE_NAME_DEFAULT_VALUE), this.getHostName(serverAddress), saslClientProperties, null)) == null) {
                throw new MongoSecurityException(credential, String.format("No platform support for %s mechanism", new Object[]{AuthenticationMechanism.GSSAPI}));
            }
            return saslClient;
        }
        catch (SaslException e) {
            throw new MongoSecurityException(credential, "Exception initializing SASL client", (Throwable)e);
        }
        catch (GSSException e) {
            throw new MongoSecurityException(credential, "Exception initializing GSSAPI credentials", (Throwable)e);
        }
        catch (UnknownHostException e) {
            throw new MongoSecurityException(credential, "Unable to canonicalize host name + " + serverAddress);
        }
    }

    private GSSCredential getGSSCredential(String userName) throws GSSException {
        Oid krb5Mechanism = new Oid(GSSAPI_OID);
        GSSManager manager = GSSManager.getInstance();
        GSSName name = manager.createName(userName, GSSName.NT_USER_NAME);
        return manager.createCredential(name, Integer.MAX_VALUE, krb5Mechanism, 1);
    }

    private String getHostName(ServerAddress serverAddress) throws UnknownHostException {
        return this.getNonNullMechanismProperty("CANONICALIZE_HOST_NAME", CANONICALIZE_HOST_NAME_DEFAULT_VALUE) != false ? InetAddress.getByName(serverAddress.getHost()).getCanonicalHostName() : serverAddress.getHost();
    }

    @Override
    @NonNull
    protected SubjectProvider getDefaultSubjectProvider() {
        return new KerberosSubjectProvider();
    }
}

