/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.connection;

import java.util.List;
import net.zaiyers.UUIDDB.lib.bson.BsonArray;
import net.zaiyers.UUIDDB.lib.bson.BsonBoolean;
import net.zaiyers.UUIDDB.lib.bson.BsonDocument;
import net.zaiyers.UUIDDB.lib.bson.BsonInt32;
import net.zaiyers.UUIDDB.lib.bson.BsonString;
import net.zaiyers.UUIDDB.lib.mongodb.MongoCompressor;
import net.zaiyers.UUIDDB.lib.mongodb.MongoCredential;
import net.zaiyers.UUIDDB.lib.mongodb.MongoException;
import net.zaiyers.UUIDDB.lib.mongodb.MongoSecurityException;
import net.zaiyers.UUIDDB.lib.mongodb.ServerApi;
import net.zaiyers.UUIDDB.lib.mongodb.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ClusterConnectionMode;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ConnectionDescription;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ConnectionId;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ServerDescription;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ServerType;
import net.zaiyers.UUIDDB.lib.mongodb.internal.async.SingleResultCallback;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.Authenticator;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.CommandHelper;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.DefaultAuthenticator;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.DescriptionHelper;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.InternalConnection;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.InternalConnectionInitializationDescription;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.InternalConnectionInitializer;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.SpeculativeAuthenticator;
import net.zaiyers.UUIDDB.lib.mongodb.lang.Nullable;

public class InternalStreamConnectionInitializer
implements InternalConnectionInitializer {
    private final ClusterConnectionMode clusterConnectionMode;
    private final Authenticator authenticator;
    private final BsonDocument clientMetadataDocument;
    private final List<MongoCompressor> requestedCompressors;
    private final boolean checkSaslSupportedMechs;
    private final ServerApi serverApi;

    public InternalStreamConnectionInitializer(ClusterConnectionMode clusterConnectionMode, @Nullable Authenticator authenticator, BsonDocument clientMetadataDocument, List<MongoCompressor> requestedCompressors, @Nullable ServerApi serverApi) {
        this.clusterConnectionMode = clusterConnectionMode;
        this.authenticator = authenticator;
        this.clientMetadataDocument = clientMetadataDocument;
        this.requestedCompressors = Assertions.notNull("requestedCompressors", requestedCompressors);
        this.checkSaslSupportedMechs = authenticator instanceof DefaultAuthenticator;
        this.serverApi = serverApi;
    }

    @Override
    public InternalConnectionInitializationDescription startHandshake(InternalConnection internalConnection) {
        Assertions.notNull("internalConnection", internalConnection);
        return this.initializeConnectionDescription(internalConnection);
    }

    @Override
    public InternalConnectionInitializationDescription finishHandshake(InternalConnection internalConnection, InternalConnectionInitializationDescription description) {
        Assertions.notNull("internalConnection", internalConnection);
        Assertions.notNull("description", description);
        this.authenticate(internalConnection, description.getConnectionDescription());
        return this.completeConnectionDescriptionInitialization(internalConnection, description);
    }

    @Override
    public void startHandshakeAsync(InternalConnection internalConnection, SingleResultCallback<InternalConnectionInitializationDescription> callback) {
        long startTime = System.nanoTime();
        CommandHelper.executeCommandAsync("admin", this.createHelloCommand(this.authenticator, internalConnection), this.clusterConnectionMode, this.serverApi, internalConnection, (helloResult, t) -> {
            if (t != null) {
                callback.onResult(null, t instanceof MongoException ? this.mapHelloException((MongoException)t) : t);
            } else {
                this.setSpeculativeAuthenticateResponse((BsonDocument)helloResult);
                callback.onResult(this.createInitializationDescription((BsonDocument)helloResult, internalConnection, startTime), null);
            }
        });
    }

    @Override
    public void finishHandshakeAsync(InternalConnection internalConnection, InternalConnectionInitializationDescription description, SingleResultCallback<InternalConnectionInitializationDescription> callback) {
        if (this.authenticator == null || description.getConnectionDescription().getServerType() == ServerType.REPLICA_SET_ARBITER) {
            this.completeConnectionDescriptionInitializationAsync(internalConnection, description, callback);
        } else {
            this.authenticator.authenticateAsync(internalConnection, description.getConnectionDescription(), (result1, t1) -> {
                if (t1 != null) {
                    callback.onResult(null, t1);
                } else {
                    this.completeConnectionDescriptionInitializationAsync(internalConnection, description, callback);
                }
            });
        }
    }

    private InternalConnectionInitializationDescription initializeConnectionDescription(InternalConnection internalConnection) {
        BsonDocument helloResult;
        BsonDocument helloCommandDocument = this.createHelloCommand(this.authenticator, internalConnection);
        long start = System.nanoTime();
        try {
            helloResult = CommandHelper.executeCommand("admin", helloCommandDocument, this.clusterConnectionMode, this.serverApi, internalConnection);
        }
        catch (MongoException e) {
            throw this.mapHelloException(e);
        }
        this.setSpeculativeAuthenticateResponse(helloResult);
        return this.createInitializationDescription(helloResult, internalConnection, start);
    }

    private MongoException mapHelloException(MongoException e) {
        if (this.checkSaslSupportedMechs && e.getCode() == 11) {
            MongoCredential credential = this.authenticator.getMongoCredential();
            return new MongoSecurityException(credential, String.format("Exception authenticating %s", credential), (Throwable)e);
        }
        return e;
    }

    private InternalConnectionInitializationDescription createInitializationDescription(BsonDocument helloResult, InternalConnection internalConnection, long startTime) {
        ConnectionId connectionId = internalConnection.getDescription().getConnectionId();
        ConnectionDescription connectionDescription = DescriptionHelper.createConnectionDescription(this.clusterConnectionMode, connectionId, helloResult);
        ServerDescription serverDescription = DescriptionHelper.createServerDescription(internalConnection.getDescription().getServerAddress(), helloResult, System.nanoTime() - startTime);
        return new InternalConnectionInitializationDescription(connectionDescription, serverDescription);
    }

    private BsonDocument createHelloCommand(Authenticator authenticator, InternalConnection connection) {
        BsonDocument speculativeAuthenticateDocument;
        BsonDocument helloCommandDocument = new BsonDocument(this.getHandshakeCommandName(), new BsonInt32(1)).append("helloOk", BsonBoolean.TRUE);
        if (this.clientMetadataDocument != null) {
            helloCommandDocument.append("client", this.clientMetadataDocument);
        }
        if (this.clusterConnectionMode == ClusterConnectionMode.LOAD_BALANCED) {
            helloCommandDocument.append("loadBalanced", BsonBoolean.TRUE);
        }
        if (!this.requestedCompressors.isEmpty()) {
            BsonArray compressors = new BsonArray(this.requestedCompressors.size());
            for (MongoCompressor cur : this.requestedCompressors) {
                compressors.add(new BsonString(cur.getName()));
            }
            helloCommandDocument.append("compression", compressors);
        }
        if (this.checkSaslSupportedMechs) {
            MongoCredential credential = authenticator.getMongoCredential();
            helloCommandDocument.append("saslSupportedMechs", new BsonString(credential.getSource() + "." + credential.getUserName()));
        }
        if (authenticator instanceof SpeculativeAuthenticator && (speculativeAuthenticateDocument = ((SpeculativeAuthenticator)((Object)authenticator)).createSpeculativeAuthenticateCommand(connection)) != null) {
            helloCommandDocument.append("speculativeAuthenticate", speculativeAuthenticateDocument);
        }
        return helloCommandDocument;
    }

    private InternalConnectionInitializationDescription completeConnectionDescriptionInitialization(InternalConnection internalConnection, InternalConnectionInitializationDescription description) {
        if (description.getConnectionDescription().getConnectionId().getServerValue() != null) {
            return description;
        }
        return this.applyGetLastErrorResult(CommandHelper.executeCommandWithoutCheckingForFailure("admin", new BsonDocument("getlasterror", new BsonInt32(1)), this.clusterConnectionMode, this.serverApi, internalConnection), description);
    }

    private void authenticate(InternalConnection internalConnection, ConnectionDescription connectionDescription) {
        if (this.authenticator != null && connectionDescription.getServerType() != ServerType.REPLICA_SET_ARBITER) {
            this.authenticator.authenticate(internalConnection, connectionDescription);
        }
    }

    private void setSpeculativeAuthenticateResponse(BsonDocument helloResult) {
        if (this.authenticator instanceof SpeculativeAuthenticator) {
            ((SpeculativeAuthenticator)((Object)this.authenticator)).setSpeculativeAuthenticateResponse(helloResult.getDocument("speculativeAuthenticate", null));
        }
    }

    private void completeConnectionDescriptionInitializationAsync(InternalConnection internalConnection, InternalConnectionInitializationDescription description, SingleResultCallback<InternalConnectionInitializationDescription> callback) {
        if (description.getConnectionDescription().getConnectionId().getServerValue() != null) {
            callback.onResult(description, null);
            return;
        }
        CommandHelper.executeCommandAsync("admin", new BsonDocument("getlasterror", new BsonInt32(1)), this.clusterConnectionMode, this.serverApi, internalConnection, (result, t) -> {
            if (t != null) {
                callback.onResult(description, null);
            } else {
                callback.onResult(this.applyGetLastErrorResult((BsonDocument)result, description), null);
            }
        });
    }

    private InternalConnectionInitializationDescription applyGetLastErrorResult(BsonDocument getLastErrorResult, InternalConnectionInitializationDescription description) {
        ConnectionDescription connectionDescription = description.getConnectionDescription();
        ConnectionId connectionId = getLastErrorResult.containsKey("connectionId") ? connectionDescription.getConnectionId().withServerValue(getLastErrorResult.getNumber("connectionId").intValue()) : connectionDescription.getConnectionId();
        return description.withConnectionDescription(connectionDescription.withConnectionId(connectionId));
    }

    private String getHandshakeCommandName() {
        return this.serverApi == null ? "isMaster" : "hello";
    }
}

