/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.connection.tlschannel;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.tlschannel.BufferAllocator;

public class TrackingAllocator
implements BufferAllocator {
    private final BufferAllocator impl;
    private final LongAdder bytesAllocatedAdder = new LongAdder();
    private final LongAdder bytesDeallocatedAdder = new LongAdder();
    private final AtomicLong currentAllocationSize = new AtomicLong();
    private final LongAccumulator maxAllocationSizeAcc = new LongAccumulator(Math::max, 0L);
    private final LongAdder buffersAllocatedAdder = new LongAdder();
    private final LongAdder buffersDeallocatedAdder = new LongAdder();

    public TrackingAllocator(BufferAllocator impl) {
        this.impl = impl;
    }

    @Override
    public ByteBuffer allocate(int size) {
        this.bytesAllocatedAdder.add(size);
        this.currentAllocationSize.addAndGet(size);
        this.buffersAllocatedAdder.increment();
        return this.impl.allocate(size);
    }

    @Override
    public void free(ByteBuffer buffer) {
        int size = buffer.capacity();
        this.bytesDeallocatedAdder.add(size);
        this.maxAllocationSizeAcc.accumulate(this.currentAllocationSize.longValue());
        this.currentAllocationSize.addAndGet(-size);
        this.buffersDeallocatedAdder.increment();
        this.impl.free(buffer);
    }

    public long bytesAllocated() {
        return this.bytesAllocatedAdder.longValue();
    }

    public long bytesDeallocated() {
        return this.bytesDeallocatedAdder.longValue();
    }

    public long currentAllocation() {
        return this.currentAllocationSize.longValue();
    }

    public long maxAllocation() {
        return this.maxAllocationSizeAcc.longValue();
    }

    public long buffersAllocated() {
        return this.buffersAllocatedAdder.longValue();
    }

    public long buffersDeallocated() {
        return this.buffersDeallocatedAdder.longValue();
    }
}

