/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.event;

import java.util.ArrayList;
import java.util.List;
import net.zaiyers.UUIDDB.lib.mongodb.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.mongodb.event.ServerClosedEvent;
import net.zaiyers.UUIDDB.lib.mongodb.event.ServerDescriptionChangedEvent;
import net.zaiyers.UUIDDB.lib.mongodb.event.ServerListener;
import net.zaiyers.UUIDDB.lib.mongodb.event.ServerOpeningEvent;
import net.zaiyers.UUIDDB.lib.mongodb.internal.diagnostics.logging.Logger;
import net.zaiyers.UUIDDB.lib.mongodb.internal.diagnostics.logging.Loggers;

final class ServerListenerMulticaster
implements ServerListener {
    private static final Logger LOGGER = Loggers.getLogger("cluster.event");
    private final List<ServerListener> serverListeners;

    ServerListenerMulticaster(List<ServerListener> serverListeners) {
        Assertions.isTrue("All ServerListener instances are non-null", !serverListeners.contains(null));
        this.serverListeners = new ArrayList<ServerListener>(serverListeners);
    }

    @Override
    public void serverOpening(ServerOpeningEvent event) {
        for (ServerListener cur : this.serverListeners) {
            try {
                cur.serverOpening(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server opening event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void serverClosed(ServerClosedEvent event) {
        for (ServerListener cur : this.serverListeners) {
            try {
                cur.serverClosed(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server opening event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void serverDescriptionChanged(ServerDescriptionChangedEvent event) {
        for (ServerListener cur : this.serverListeners) {
            try {
                cur.serverDescriptionChanged(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server description changed event to listener %s", cur), e);
            }
        }
    }
}

