/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.operation;

import java.util.Collections;
import java.util.List;
import net.zaiyers.UUIDDB.lib.bson.BsonDocument;
import net.zaiyers.UUIDDB.lib.bson.BsonDocumentWrapper;
import net.zaiyers.UUIDDB.lib.bson.BsonReader;
import net.zaiyers.UUIDDB.lib.bson.BsonType;
import net.zaiyers.UUIDDB.lib.bson.BsonValue;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonDocumentCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.Codec;
import net.zaiyers.UUIDDB.lib.bson.codecs.Decoder;
import net.zaiyers.UUIDDB.lib.bson.codecs.DecoderContext;
import net.zaiyers.UUIDDB.lib.bson.codecs.configuration.CodecRegistries;
import net.zaiyers.UUIDDB.lib.bson.codecs.configuration.CodecRegistry;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.CommandResultArrayCodec;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.CommandResultCodecProvider;

class CommandResultDocumentCodec<T>
extends BsonDocumentCodec {
    private final Decoder<T> payloadDecoder;
    private final List<String> fieldsContainingPayload;

    CommandResultDocumentCodec(CodecRegistry registry, Decoder<T> payloadDecoder, List<String> fieldsContainingPayload) {
        super(registry);
        this.payloadDecoder = payloadDecoder;
        this.fieldsContainingPayload = fieldsContainingPayload;
    }

    static <P> Codec<BsonDocument> create(Decoder<P> decoder, String fieldContainingPayload) {
        return CommandResultDocumentCodec.create(decoder, Collections.singletonList(fieldContainingPayload));
    }

    static <P> Codec<BsonDocument> create(Decoder<P> decoder, List<String> fieldsContainingPayload) {
        CodecRegistry registry = CodecRegistries.fromProviders(new CommandResultCodecProvider<P>(decoder, fieldsContainingPayload));
        return registry.get(BsonDocument.class);
    }

    @Override
    protected BsonValue readValue(BsonReader reader, DecoderContext decoderContext) {
        if (this.fieldsContainingPayload.contains(reader.getCurrentName())) {
            if (reader.getCurrentBsonType() == BsonType.DOCUMENT) {
                return new BsonDocumentWrapper<T>(this.payloadDecoder.decode(reader, decoderContext), null);
            }
            if (reader.getCurrentBsonType() == BsonType.ARRAY) {
                return new CommandResultArrayCodec<T>(this.getCodecRegistry(), this.payloadDecoder).decode(reader, decoderContext);
            }
        }
        return super.readValue(reader, decoderContext);
    }
}

