/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.velocity;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.zaiyers.UUIDDB.velocity.UUIDDB;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.serialize.SerializationException;

public class PluginConfig {
    private static final Pattern PATH_PATTERN = Pattern.compile("\\.");
    private final UUIDDB plugin;
    private final Path configFile;
    private final String defaultFile;
    private final HoconConfigurationLoader configLoader;
    private ConfigurationNode config;
    private ConfigurationNode defaultConfig;

    public PluginConfig(UUIDDB plugin, Path configFile) {
        this(plugin, configFile, configFile.getFileName().toString());
    }

    public PluginConfig(UUIDDB plugin, Path configFile, String defaultFile) {
        this.plugin = plugin;
        this.configFile = configFile;
        this.defaultFile = defaultFile;
        this.configLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(configFile)).build();
    }

    public boolean load() {
        try {
            this.config = this.configLoader.load();
            if (this.defaultFile != null && this.plugin.getClass().getClassLoader().getResource(this.defaultFile) != null) {
                this.defaultConfig = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(this.configFile)).source(() -> new BufferedReader(new InputStreamReader(this.plugin.getClass().getClassLoader().getResourceAsStream(this.defaultFile))))).build().load();
                if (this.config.empty()) {
                    this.config = this.defaultConfig.copy();
                }
            }
            this.plugin.getLogger().info("Loaded " + String.valueOf(this.configFile.getFileName()));
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Unable to load configuration file " + String.valueOf(this.configFile.getFileName()), e);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean createDefaultConfig() throws IOException {
        block14: {
            try (InputStream in = this.plugin.getClass().getClassLoader().getResourceAsStream(this.defaultFile);){
                if (in == null) {
                    this.plugin.getLogger().severe("No default config '" + this.defaultFile + "' found in " + this.plugin.getClass().getSimpleName() + "!");
                    boolean bl = false;
                    return bl;
                }
                if (Files.exists(this.configFile, new LinkOption[0])) break block14;
                Path parent = this.configFile.getParent();
                if (!Files.exists(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                try {
                    Files.copy(in, this.configFile, new CopyOption[0]);
                    boolean bl = true;
                    return bl;
                }
                catch (IOException ex) {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not save '" + this.defaultFile + "' to " + String.valueOf(this.configFile), ex);
                }
            }
            catch (IOException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not load default config from " + this.defaultFile, ex);
            }
        }
        return false;
    }

    public void save() {
        try {
            this.configLoader.save(this.config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Object set(String path, Object value) {
        ConfigurationNode node = this.config.node(PluginConfig.splitPath(path));
        Object prev = node.raw();
        try {
            node.set(value);
        }
        catch (SerializationException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not set node at " + path, e);
        }
        return prev;
    }

    public ConfigurationNode remove(String path) {
        ConfigurationNode node = this.config.node(PluginConfig.splitPath(path));
        try {
            return node.virtual() ? node : node.set(null);
        }
        catch (SerializationException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not remove node at " + path, e);
            return null;
        }
    }

    public ConfigurationNode getRawConfig() {
        return this.config;
    }

    public ConfigurationNode getRawConfig(String path) {
        return this.getRawConfig().node(PluginConfig.splitPath(path));
    }

    public boolean has(String path) {
        return !this.getRawConfig(path).virtual();
    }

    public boolean isSection(String path) {
        return this.getRawConfig(path).isMap();
    }

    public int getInt(String path) {
        return this.getInt(path, 0);
    }

    public int getInt(String path, int def) {
        return this.getRawConfig(path).getInt(def);
    }

    public double getDouble(String path) {
        return this.getDouble(path, 0.0);
    }

    public double getDouble(String path, double def) {
        return this.getRawConfig(path).getDouble(def);
    }

    public String getString(String path) {
        return this.getRawConfig(path).getString();
    }

    public String getString(String path, String def) {
        return this.getRawConfig(path).getString(def);
    }

    public boolean getBoolean(String path) {
        return this.getBoolean(path, false);
    }

    public boolean getBoolean(String path, boolean def) {
        return this.getRawConfig(path).getBoolean(def);
    }

    private static Object[] splitPath(String key) {
        return PATH_PATTERN.split(key);
    }
}

