/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.velocity;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.zaiyers.UUIDDB.velocity.UUIDDB;

public class UuidDbCommand
implements SimpleCommand {
    private final UUIDDB plugin;
    private final String permission;

    public UuidDbCommand(UUIDDB plugin, String permission) {
        this.plugin = plugin;
        this.permission = permission;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        if (((String[])invocation.arguments()).length > 0) {
            for (String arg : (String[])invocation.arguments()) {
                Optional player;
                UUID uuid = null;
                String username = null;
                try {
                    uuid = UUID.fromString(arg);
                    player = this.plugin.getProxy().getPlayer(uuid);
                }
                catch (IllegalArgumentException e) {
                    username = arg;
                    player = this.plugin.getProxy().getPlayer(username);
                }
                if (player.isPresent()) {
                    this.sendInfo(sender, ((Player)player.get()).getUsername(), ((Player)player.get()).getUniqueId().toString());
                    continue;
                }
                if (uuid != null) {
                    UUID finalUuid = uuid;
                    this.plugin.getProxy().getScheduler().buildTask((Object)this.plugin, () -> {
                        String name = this.plugin.getStorage().getNameByUUID(finalUuid);
                        if (name != null) {
                            String uuidStr = this.plugin.getStorage().getUUIDByName(name, false);
                            this.sendInfo(sender, name, uuidStr);
                        } else {
                            sender.sendMessage(Component.text((String)("No Username for UUID " + String.valueOf(finalUuid) + " found!")).color((TextColor)NamedTextColor.RED));
                        }
                    });
                    continue;
                }
                if (username != null) {
                    String finalUsername = username;
                    this.plugin.getProxy().getScheduler().buildTask((Object)this.plugin, () -> {
                        String uuidStr = this.plugin.getStorage().getUUIDByName(finalUsername, false);
                        if (uuidStr != null) {
                            String name = this.plugin.getStorage().getNameByUUID(uuidStr);
                            this.sendInfo(sender, name, uuidStr);
                        } else {
                            sender.sendMessage(Component.text((String)("No UUID for username " + finalUsername + " found!")).color((TextColor)NamedTextColor.RED));
                        }
                    });
                    continue;
                }
                invocation.source().sendMessage(Component.text((String)"Something went wrong! Please report this to a developer!").color((TextColor)NamedTextColor.RED));
                this.plugin.getLogger().log(Level.WARNING, "Everything is null! Argument: " + arg);
            }
        } else if (this.plugin.isEnabled()) {
            sender.sendMessage(Component.text((String)(String.valueOf(this.plugin.getDescription().getName()) + " v" + String.valueOf(this.plugin.getDescription().getVersion()) + " by " + String.join((CharSequence)", ", this.plugin.getDescription().getAuthors()))).color((TextColor)NamedTextColor.GREEN));
            sender.sendMessage(Component.text((String)("Usage: /" + invocation.alias() + " <uuid|username>")).color((TextColor)NamedTextColor.YELLOW));
        } else {
            sender.sendMessage(Component.text((String)(String.valueOf(this.plugin.getDescription().getName()) + " did not enable correctly!")).color((TextColor)NamedTextColor.RED));
        }
    }

    private void sendInfo(CommandSource sender, String username, String uuid) {
        sender.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Username: ").color((TextColor)NamedTextColor.GREEN)).append(((TextComponent)((TextComponent)Component.text((String)username).color((TextColor)NamedTextColor.YELLOW)).clickEvent(ClickEvent.copyToClipboard((String)username))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to copy this name").color((TextColor)NamedTextColor.YELLOW))))).appendNewline()).append(Component.text((String)"UUID: ").color((TextColor)NamedTextColor.GREEN))).append(((TextComponent)((TextComponent)Component.text((String)uuid).color((TextColor)NamedTextColor.YELLOW)).clickEvent(ClickEvent.copyToClipboard((String)uuid))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to copy this uuid").color((TextColor)NamedTextColor.YELLOW)))));
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission(this.permission);
    }
}

