/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.filemappers;

import javax.annotation.Nonnull;
import javax.inject.Named;
import org.codehaus.plexus.components.io.filemappers.AbstractFileMapper;

@Named(value="fileExtension")
public class FileExtensionMapper
extends AbstractFileMapper {
    public static final String ROLE_HINT = "fileExtension";
    private String targetExtension;

    public void setTargetExtension(String pTargetExtension) {
        if (pTargetExtension == null) {
            throw new IllegalArgumentException("The target extension is null.");
        }
        if (pTargetExtension.isEmpty()) {
            throw new IllegalArgumentException("The target extension is empty.");
        }
        this.targetExtension = pTargetExtension.charAt(0) == '.' ? pTargetExtension : '.' + pTargetExtension;
    }

    public String getTargetExtension() {
        return this.targetExtension;
    }

    @Override
    @Nonnull
    public String getMappedFileName(@Nonnull String pName) {
        String ext = this.getTargetExtension();
        if (ext == null) {
            throw new IllegalStateException("The target extension has not been set.");
        }
        String name = super.getMappedFileName(pName);
        int dirSep = Math.max(pName.lastIndexOf(47), pName.lastIndexOf(92));
        int offset = pName.lastIndexOf(46);
        if (offset <= dirSep) {
            return name + ext;
        }
        return name.substring(0, offset) + ext;
    }
}

