/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.linbus.stream.impl;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.enginehub.linbus.common.LinTagId;
import org.enginehub.linbus.stream.LinStream;
import org.enginehub.linbus.stream.exception.NbtParseException;
import org.enginehub.linbus.stream.token.LinToken;
import org.jetbrains.annotations.Nullable;

public class LinNbtReader
implements LinStream {
    private final DataInput input;
    private final Deque<State> stateStack;

    public LinNbtReader(DataInput input) {
        this.input = input;
        this.stateStack = new ArrayDeque<State.Initial>(List.of(new State.Initial()));
    }

    @Override
    @Nullable
    public LinToken nextOrNull() throws IOException {
        State state = this.stateStack.pollLast();
        if (state == null) {
            return null;
        }
        if (state instanceof State.ListEntry) {
            State.ListEntry entry = (State.ListEntry)state;
            if (entry.remaining == 0) {
                return new LinToken.ListEnd();
            }
            this.stateStack.addLast(new State.ListEntry(entry.remaining - 1, entry.elementId));
            state = new State.ReadValue(entry.elementId);
        }
        if (state instanceof State.Initial) {
            if (this.input.readUnsignedByte() != LinTagId.COMPOUND.id()) {
                throw new NbtParseException("NBT stream does not start with a compound tag");
            }
            this.stateStack.addLast(new State.CompoundStart());
            return new LinToken.Name(this.input.readUTF(), LinTagId.COMPOUND);
        }
        if (state instanceof State.CompoundStart) {
            this.stateStack.addLast(new State.CompoundEntryName());
            return new LinToken.CompoundStart();
        }
        if (state instanceof State.CompoundEntryName) {
            LinTagId id = LinTagId.fromId((int)this.input.readUnsignedByte());
            if (id == LinTagId.END) {
                return new LinToken.CompoundEnd();
            }
            this.stateStack.addLast(new State.CompoundEntryName());
            this.stateStack.addLast(new State.ReadValue(id));
            return new LinToken.Name(this.input.readUTF(), id);
        }
        if (state instanceof State.ReadValue) {
            State.ReadValue rv = (State.ReadValue)state;
            return switch (rv.id()) {
                default -> throw new IncompatibleClassChangeError();
                case LinTagId.BYTE -> new LinToken.Byte(this.input.readByte());
                case LinTagId.SHORT -> new LinToken.Short(this.input.readShort());
                case LinTagId.INT -> new LinToken.Int(this.input.readInt());
                case LinTagId.LONG -> new LinToken.Long(this.input.readLong());
                case LinTagId.FLOAT -> new LinToken.Float(this.input.readFloat());
                case LinTagId.DOUBLE -> new LinToken.Double(this.input.readDouble());
                case LinTagId.BYTE_ARRAY -> {
                    int size = this.input.readInt();
                    this.stateStack.addLast(new State.ReadByteArray(size));
                    yield new LinToken.ByteArrayStart(size);
                }
                case LinTagId.STRING -> new LinToken.String(this.input.readUTF());
                case LinTagId.LIST -> {
                    LinTagId elementId = LinTagId.fromId((int)this.input.readUnsignedByte());
                    int size = this.input.readInt();
                    this.stateStack.addLast(new State.ListEntry(size, elementId));
                    yield new LinToken.ListStart(size, elementId);
                }
                case LinTagId.COMPOUND -> {
                    this.stateStack.addLast(new State.CompoundEntryName());
                    yield new LinToken.CompoundStart();
                }
                case LinTagId.INT_ARRAY -> {
                    int size = this.input.readInt();
                    this.stateStack.addLast(new State.ReadIntArray(size));
                    yield new LinToken.IntArrayStart(size);
                }
                case LinTagId.LONG_ARRAY -> {
                    int size = this.input.readInt();
                    this.stateStack.addLast(new State.ReadLongArray(size));
                    yield new LinToken.LongArrayStart(size);
                }
                case LinTagId.END -> throw new NbtParseException("Invalid id: " + rv.id());
            };
        }
        if (state instanceof State.ReadByteArray) {
            State.ReadByteArray rba = (State.ReadByteArray)state;
            if (rba.remaining == 0) {
                return new LinToken.ByteArrayEnd();
            }
            ByteBuffer buffer = ByteBuffer.allocate(Math.min(8192, rba.remaining));
            this.input.readFully(buffer.array(), buffer.position(), buffer.remaining());
            this.stateStack.addLast(new State.ReadByteArray(rba.remaining - buffer.remaining()));
            return new LinToken.ByteArrayContent(buffer.asReadOnlyBuffer());
        }
        if (state instanceof State.ReadIntArray) {
            State.ReadIntArray ria = (State.ReadIntArray)state;
            if (ria.remaining == 0) {
                return new LinToken.IntArrayEnd();
            }
            ByteBuffer buffer = ByteBuffer.allocate(Math.min(8192, ria.remaining * 4));
            this.input.readFully(buffer.array(), buffer.position(), buffer.remaining());
            this.stateStack.addLast(new State.ReadIntArray(ria.remaining - buffer.remaining() / 4));
            return new LinToken.IntArrayContent(buffer.asIntBuffer().asReadOnlyBuffer());
        }
        if (state instanceof State.ReadLongArray) {
            State.ReadLongArray rla = (State.ReadLongArray)state;
            if (rla.remaining == 0) {
                return new LinToken.LongArrayEnd();
            }
            ByteBuffer buffer = ByteBuffer.allocate(Math.min(8192, rla.remaining * 8));
            this.input.readFully(buffer.array(), buffer.position(), buffer.remaining());
            this.stateStack.addLast(new State.ReadLongArray(rla.remaining - buffer.remaining() / 8));
            return new LinToken.LongArrayContent(buffer.asLongBuffer().asReadOnlyBuffer());
        }
        throw new AssertionError((Object)"Missing state handler (switch patterns wen)");
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface State {

        public record ReadLongArray(int remaining) implements State
        {
        }

        public record ReadIntArray(int remaining) implements State
        {
        }

        public record ReadByteArray(int remaining) implements State
        {
        }

        public record ReadValue(LinTagId id) implements State
        {
        }

        public record ListEntry(int remaining, LinTagId elementId) implements State
        {
        }

        public record CompoundEntryName() implements State
        {
        }

        public record CompoundStart() implements State
        {
        }

        public record Initial() implements State
        {
        }
    }
}

