/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.crypto;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import org.geysermc.floodgate.util.InvalidFormatException;

public interface FloodgateCipher {
    public static final byte[] IDENTIFIER = "^Floodgate^".getBytes(StandardCharsets.UTF_8);
    public static final int HEADER_LENGTH = IDENTIFIER.length;

    public static boolean hasHeader(String data) {
        if (data.length() < IDENTIFIER.length) {
            return false;
        }
        for (int i = 0; i < IDENTIFIER.length; ++i) {
            if (IDENTIFIER[i] == data.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public void init(Key var1);

    public byte[] encrypt(byte[] var1) throws Exception;

    default public byte[] encryptFromString(String data) throws Exception {
        return this.encrypt(data.getBytes(StandardCharsets.UTF_8));
    }

    public byte[] decrypt(byte[] var1) throws Exception;

    default public String decryptToString(byte[] data) throws Exception {
        byte[] decrypted = this.decrypt(data);
        if (decrypted == null) {
            return null;
        }
        return new String(decrypted, StandardCharsets.UTF_8);
    }

    default public byte[] decryptFromString(String data) throws Exception {
        return this.decrypt(data.getBytes(StandardCharsets.UTF_8));
    }

    default public void checkHeader(byte[] data) throws InvalidFormatException {
        int identifierLength = IDENTIFIER.length;
        if (data.length <= HEADER_LENGTH) {
            throw new InvalidFormatException("Data length is smaller then header.Needed " + HEADER_LENGTH + ", got " + data.length, true);
        }
        for (int i = 0; i < identifierLength; ++i) {
            if (IDENTIFIER[i] == data[i]) continue;
            StringBuilder receivedIdentifier = new StringBuilder();
            for (byte b : IDENTIFIER) {
                receivedIdentifier.append(b);
            }
            throw new InvalidFormatException(String.format("Expected identifier %s, got %s", new String(IDENTIFIER, StandardCharsets.UTF_8), receivedIdentifier.toString()), true);
        }
    }

    public static class HeaderResult {
        private int version;
        private int startIndex;

        public int getVersion() {
            return this.version;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public void setStartIndex(int startIndex) {
            this.startIndex = startIndex;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HeaderResult)) {
                return false;
            }
            HeaderResult other = (HeaderResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            return this.getStartIndex() == other.getStartIndex();
        }

        protected boolean canEqual(Object other) {
            return other instanceof HeaderResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getVersion();
            result = result * 59 + this.getStartIndex();
            return result;
        }

        public String toString() {
            return "FloodgateCipher.HeaderResult(version=" + this.getVersion() + ", startIndex=" + this.getStartIndex() + ")";
        }

        public HeaderResult(int version, int startIndex) {
            this.version = version;
            this.startIndex = startIndex;
        }
    }
}

