/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.news;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geysermc.floodgate.news.NewsItemAction;
import org.geysermc.floodgate.news.NewsItemMessage;
import org.geysermc.floodgate.news.NewsType;
import org.geysermc.floodgate.news.data.ItemData;

public final class NewsItem {
    private final int id;
    private final String project;
    private final boolean active;
    private final NewsType type;
    private final ItemData data;
    private final boolean priority;
    private final String message;
    private final Set<NewsItemAction> actions;
    private final String url;

    private NewsItem(int id, String project, boolean active, NewsType type, ItemData data, boolean priority, String message, Set<NewsItemAction> actions, String url) {
        this.id = id;
        this.project = project;
        this.active = active;
        this.type = type;
        this.data = data;
        this.priority = priority;
        this.message = message;
        this.actions = Collections.unmodifiableSet(actions);
        this.url = url;
    }

    public static NewsItem readItem(JsonObject newsItem) {
        NewsType newsType = NewsType.getByName(newsItem.get("type").getAsString());
        if (newsType == null) {
            return null;
        }
        JsonObject messageObject = newsItem.getAsJsonObject("message");
        NewsItemMessage itemMessage = NewsItemMessage.getById(messageObject.get("id").getAsInt());
        String message = "Received an unknown news message type. Please update";
        if (itemMessage != null) {
            message = itemMessage.getFormattedMessage(messageObject.getAsJsonArray("args"));
        }
        HashSet<NewsItemAction> actions = new HashSet<NewsItemAction>();
        for (JsonElement actionElement : newsItem.getAsJsonArray("actions")) {
            NewsItemAction action = NewsItemAction.getByName(actionElement.getAsString());
            if (action == null) continue;
            actions.add(action);
        }
        return new NewsItem(newsItem.get("id").getAsInt(), newsItem.get("project").getAsString(), newsItem.get("active").getAsBoolean(), newsType, newsType.read(newsItem.getAsJsonObject("data")), newsItem.get("priority").getAsBoolean(), message, actions, newsItem.get("url").getAsString());
    }

    public int getId() {
        return this.id;
    }

    public String getProject() {
        return this.project;
    }

    public boolean isGlobal() {
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public NewsType getType() {
        return this.type;
    }

    public ItemData getData() {
        return this.data;
    }

    public <T extends ItemData> T getDataAs(Class<T> type) {
        return (T)this.data;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public String getRawMessage() {
        return this.message;
    }

    public String getMessage() {
        return this.message + " See " + this.getUrl() + " for more information.";
    }

    public Set<NewsItemAction> getActions() {
        return this.actions;
    }

    public String getUrl() {
        return this.url;
    }
}

