/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.news;

import com.google.gson.JsonObject;
import java.util.function.Function;
import org.geysermc.floodgate.news.data.BuildSpecificData;
import org.geysermc.floodgate.news.data.CheckAfterData;
import org.geysermc.floodgate.news.data.ItemData;

public enum NewsType {
    BUILD_SPECIFIC(BuildSpecificData::read),
    CHECK_AFTER(CheckAfterData::read);

    private static final NewsType[] VALUES;
    private final Function<JsonObject, ? extends ItemData> readFunction;

    private NewsType(Function<JsonObject, ? extends ItemData> readFunction) {
        this.readFunction = readFunction;
    }

    public static NewsType getByName(String newsType) {
        for (NewsType type : VALUES) {
            if (!type.name().equalsIgnoreCase(newsType)) continue;
            return type;
        }
        return null;
    }

    public ItemData read(JsonObject data) {
        return this.readFunction.apply(data);
    }

    static {
        VALUES = NewsType.values();
    }
}

