/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.news.data;

import com.google.gson.JsonObject;
import org.geysermc.floodgate.news.data.ItemData;

public final class BuildSpecificData
implements ItemData {
    private String branch;
    private boolean allAffected;
    private int affectedGreaterThan;
    private int affectedLessThan;

    public static BuildSpecificData read(JsonObject data) {
        BuildSpecificData updateData = new BuildSpecificData();
        updateData.branch = data.get("branch").getAsString();
        JsonObject affectedBuilds = data.getAsJsonObject("affected_builds");
        if (affectedBuilds.has("all")) {
            updateData.allAffected = affectedBuilds.get("all").getAsBoolean();
        }
        if (!updateData.allAffected) {
            updateData.affectedGreaterThan = affectedBuilds.get("gt").getAsInt();
            updateData.affectedLessThan = affectedBuilds.get("lt").getAsInt();
        }
        return updateData;
    }

    public boolean isAffected(String branch, int buildId) {
        return this.branch.equals(branch) && (this.allAffected || buildId > this.affectedGreaterThan && buildId < this.affectedLessThan);
    }

    public String getBranch() {
        return this.branch;
    }
}

