/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.time;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.ByteBuffer;

public final class SntpClientUtils {
    private static final int NTP_PORT = 123;
    private static final int NTP_PACKET_SIZE = 48;
    private static final int NTP_MODE = 3;
    private static final int NTP_VERSION = 3;
    private static final int RECEIVE_TIME_POSITION = 32;
    private static final long NTP_TIME_OFFSET = 2208988800L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long requestTimeOffset(String host, int timeout) {
        try (DatagramSocket socket = new DatagramSocket();){
            socket.setSoTimeout(timeout);
            InetAddress address = InetAddress.getByName(host);
            ByteBuffer buff = ByteBuffer.allocate(48);
            DatagramPacket request = new DatagramPacket(buff.array(), 48, address, 123);
            buff.put((byte)27);
            long originateTime = System.currentTimeMillis();
            socket.send(request);
            DatagramPacket response = new DatagramPacket(buff.array(), 48);
            socket.receive(response);
            long responseTime = System.currentTimeMillis();
            buff.position(32);
            long receiveTime = SntpClientUtils.readTimestamp(buff);
            long transmitTime = SntpClientUtils.readTimestamp(buff);
            long l = (receiveTime - originateTime + (transmitTime - responseTime)) / 2L;
            return l;
        }
        catch (Exception exception) {
            return Long.MIN_VALUE;
        }
    }

    private static long readTimestamp(ByteBuffer buffer) {
        long seconds = (long)buffer.getInt() & 0xFFFFFFFFL;
        long fraction = (long)buffer.getInt() & 0xFFFFFFFFL;
        return (seconds - 2208988800L) * 1000L + fraction * 1000L / 0x100000000L;
    }
}

