/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.time;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.geysermc.floodgate.time.SntpClientUtils;

public final class TimeSyncer {
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    private long timeOffset = Long.MIN_VALUE;

    public TimeSyncer(String timeServer) {
        this.executorService.scheduleWithFixedDelay(() -> {
            for (int i = 0; i < 5; ++i) {
                long offset = SntpClientUtils.requestTimeOffset(timeServer, 3000);
                if (offset == Long.MIN_VALUE) continue;
                this.timeOffset = offset;
                return;
            }
        }, 0L, 30L, TimeUnit.MINUTES);
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    public long getTimeOffset() {
        return this.timeOffset;
    }

    public long getRealMillis() {
        if (this.hasUsefulOffset()) {
            return System.currentTimeMillis() + this.getTimeOffset();
        }
        return System.currentTimeMillis();
    }

    public boolean hasUsefulOffset() {
        return this.timeOffset != Long.MIN_VALUE;
    }
}

