/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.event.bus.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeToken;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.event.bus.BaseBus;
import org.geysermc.event.bus.impl.util.Utils;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.event.subscribe.Subscriber;
import org.geysermc.event.util.TriConsumer;
import org.lanternpowered.lmbda.LambdaFactory;

abstract class BaseBusImpl<E, S extends Subscriber<? extends E>>
implements BaseBus<E, S> {
    private static final MethodHandles.Lookup CALLER = MethodHandles.lookup();
    private Class<? super E> eventType;
    private final SetMultimap<Class<?>, Subscriber<?>> subscribers = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private final SetMultimap<Subscriber<?>, Class<?>> subscriberCacheEntries = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private final LoadingCache<Class<?>, List<Subscriber<?>>> sortedSubscribersCache = CacheBuilder.newBuilder().removalListener(listener -> {
        Class eventClass = (Class)listener.getKey();
        List subscribers = (List)listener.getValue();
        SetMultimap<Subscriber<?>, Class<?>> setMultimap = this.subscriberCacheEntries;
        synchronized (setMultimap) {
            for (Subscriber subscriber : subscribers) {
                this.subscriberCacheEntries.remove((Object)subscriber, (Object)eventClass);
            }
        }
    }).build(CacheLoader.from(eventClass -> {
        Set<Class<?>> ancestors = Utils.ancestorsThatUse(eventClass, this.eventType);
        List sortedSubscribers = new ArrayList<Subscriber>();
        Object object = this.subscribers;
        synchronized (object) {
            for (Class<?> ancestor : ancestors) {
                sortedSubscribers.addAll(this.subscribers.get(ancestor));
            }
        }
        sortedSubscribers.sort(Comparator.comparingInt(s -> s.order().ordinal()));
        sortedSubscribers = Collections.unmodifiableList(sortedSubscribers);
        object = this.subscriberCacheEntries;
        synchronized (object) {
            for (Subscriber subscriber : sortedSubscribers) {
                this.subscriberCacheEntries.put((Object)subscriber, eventClass);
            }
        }
        return sortedSubscribers;
    }));

    public BaseBusImpl() {
        this.eventType = new TypeToken<E>(this.getClass()){}.getRawType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends E> void register(Class<T> eventClass, S subscriber) {
        Preconditions.checkArgument((boolean)this.eventType.isAssignableFrom(eventClass));
        Preconditions.checkArgument((boolean)subscriber.eventClass().isAssignableFrom(eventClass));
        SetMultimap<Class<?>, Subscriber<?>> setMultimap = this.subscribers;
        synchronized (setMultimap) {
            this.subscribers.put(eventClass, subscriber);
            this.sortedSubscribersCache.invalidate(eventClass);
        }
    }

    protected <T extends E> void findSubscriptions(@NonNull Object listener, TriConsumer<Class<T>, Subscribe, BiConsumer<Object, T>> consumer) {
        for (Class<?> currentClass = listener.getClass(); currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Method method : currentClass.getDeclaredMethods()) {
                Class<?> firstParameterType;
                Subscribe subscribe = method.getAnnotation(Subscribe.class);
                if (subscribe == null || method.getParameterCount() > 1 || !this.eventType.isAssignableFrom(firstParameterType = method.getParameters()[0].getType())) continue;
                method.setAccessible(true);
                try {
                    consumer.accept(firstParameterType, subscribe, LambdaFactory.createBiConsumer((MethodHandle)CALLER.unreflect(method)));
                }
                catch (IllegalAccessException exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(@NonNull S subscription) {
        SetMultimap<Class<?>, Subscriber<?>> setMultimap = this.subscribers;
        synchronized (setMultimap) {
            Class eventClass = subscription.eventClass();
            if (!this.subscribers.remove(eventClass, subscription)) {
                this.sortedSubscribersCache.invalidate(eventClass);
            }
        }
    }

    protected void unsubscribeMany(Iterable<S> subscriptions) {
        for (Subscriber subscription : subscriptions) {
            this.unsubscribe(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsubscribeAll() {
        SetMultimap<Class<?>, Subscriber<?>> setMultimap = this.subscribers;
        synchronized (setMultimap) {
            this.subscribers.clear();
        }
        this.sortedSubscribersCache.invalidateAll();
    }

    @Override
    public boolean fire(@NonNull E event) {
        boolean successful = true;
        for (Subscriber subscriber : this.sortedSubscribers(event.getClass())) {
            if (!Utils.shouldCallSubscriber(subscriber, event)) continue;
            try {
                subscriber.invoke(event);
            }
            catch (Throwable throwable) {
                successful = false;
            }
        }
        return successful;
    }

    protected List<S> sortedSubscribers(Class<?> eventClass) {
        return (List)this.sortedSubscribersCache.getUnchecked(eventClass);
    }

    protected <T extends Subscriber<U>, U> Set<T> eventSubscribers(Class<U> eventType) {
        return BaseBusImpl.castGenericSet(this.subscribers.get(eventType));
    }

    protected static <T extends U, U> Set<T> castGenericSet(Set<U> o) {
        return o;
    }
}

