/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.api.player;

import java.util.UUID;
import org.geysermc.cumulus.Form;
import org.geysermc.cumulus.util.FormBuilder;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.PropertyKey;
import org.geysermc.floodgate.util.DeviceOs;
import org.geysermc.floodgate.util.InputMode;
import org.geysermc.floodgate.util.LinkedPlayer;
import org.geysermc.floodgate.util.UiProfile;

public interface FloodgatePlayer {
    public String getJavaUsername();

    public UUID getJavaUniqueId();

    public UUID getCorrectUniqueId();

    public String getCorrectUsername();

    public String getVersion();

    public String getUsername();

    public String getXuid();

    public DeviceOs getDeviceOs();

    public String getLanguageCode();

    public UiProfile getUiProfile();

    public InputMode getInputMode();

    public boolean isFromProxy();

    public LinkedPlayer getLinkedPlayer();

    public boolean isLinked();

    default public boolean sendForm(Form form) {
        return FloodgateApi.getInstance().sendForm(this.getCorrectUniqueId(), form);
    }

    default public boolean sendForm(FormBuilder<?, ?> formBuilder) {
        return this.sendForm(formBuilder.build());
    }

    public boolean hasProperty(PropertyKey var1);

    public boolean hasProperty(String var1);

    public <T> T getProperty(PropertyKey var1);

    public <T> T getProperty(String var1);

    public <T> T removeProperty(PropertyKey var1);

    public <T> T removeProperty(String var1);

    public <T> T addProperty(PropertyKey var1, Object var2);

    public <T> T addProperty(String var1, Object var2);

    default public <T extends FloodgatePlayer> T as(Class<T> clazz) {
        return (T)((FloodgatePlayer)clazz.cast(this));
    }
}

