/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.api.player;

public class PropertyKey {
    public static final PropertyKey SOCKET_ADDRESS = new PropertyKey("socket_address", false, false);
    public static final PropertyKey SKIN_UPLOADED = new PropertyKey("skin_uploaded", false, false);
    private final String key;
    private final boolean changeable;
    private final boolean removable;

    public PropertyKey(String key, boolean changeable, boolean removable) {
        this.key = key;
        this.changeable = changeable;
        this.removable = removable;
    }

    public Result isAddAllowed(Object obj) {
        if (obj instanceof PropertyKey) {
            PropertyKey propertyKey = (PropertyKey)obj;
            if (this.key.equals(propertyKey.key)) {
                if ((propertyKey.changeable == this.changeable || propertyKey.changeable) && (propertyKey.removable == this.removable || propertyKey.removable)) {
                    return Result.ALLOWED;
                }
                return Result.INVALID_TAGS;
            }
            return Result.NOT_EQUALS;
        }
        if (obj instanceof String) {
            if (this.key.equals(obj)) {
                if (this.changeable) {
                    return Result.ALLOWED;
                }
                return Result.NOT_ALLOWED;
            }
            return Result.INVALID_TAGS;
        }
        return Result.NOT_EQUALS;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isChangeable() {
        return this.changeable;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public static enum Result {
        NOT_EQUALS,
        INVALID_TAGS,
        NOT_ALLOWED,
        ALLOWED;

    }
}

