/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus.component.impl;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.cumulus.component.DropdownComponent;
import org.geysermc.cumulus.component.impl.ComponentImpl;
import org.geysermc.cumulus.component.util.ComponentType;

public final class DropdownComponentImpl
extends ComponentImpl
implements DropdownComponent {
    private final List<String> options;
    @SerializedName(value="default")
    private final int defaultOption;

    public DropdownComponentImpl(@NonNull String text, @NonNull List<String> options, int defaultOption) {
        super(ComponentType.DROPDOWN, text);
        Preconditions.checkNotNull(options, "options");
        Preconditions.checkArgument(defaultOption >= 0, "defaultOption");
        this.options = Collections.unmodifiableList(options);
        if (defaultOption >= options.size()) {
            defaultOption = 0;
        }
        this.defaultOption = defaultOption;
    }

    @Override
    public @NonNull List<String> options() {
        return this.options;
    }

    @Override
    public @NonNegative int defaultOption() {
        return this.defaultOption;
    }

    @Override
    public @NonNull List<String> getOptions() {
        return this.options();
    }

    @Override
    public @NonNegative int getDefaultOption() {
        return this.defaultOption();
    }

    public static class Builder
    implements DropdownComponent.Builder {
        private final List<String> options = new ArrayList<String>();
        private String text = "";
        private int defaultOption = 0;

        @Override
        public Builder text(@NonNull String text) {
            this.text = Objects.requireNonNull(text, "test");
            return this;
        }

        @Override
        public Builder option(@NonNull String option, boolean isDefault) {
            this.options.add(Objects.requireNonNull(option, "option"));
            if (isDefault) {
                this.defaultOption = this.options.size() - 1;
            }
            return this;
        }

        @Override
        public Builder option(@NonNull String option) {
            return this.option(option, false);
        }

        @Override
        public Builder defaultOption(int defaultOption) {
            Preconditions.checkArgument(defaultOption >= 0, "defaultOption");
            Preconditions.checkArgument(this.options.size() > defaultOption, "defaultOption is out of bounds");
            this.defaultOption = defaultOption;
            return this;
        }

        @Override
        public @NonNull DropdownComponentImpl build() {
            return new DropdownComponentImpl(this.text, this.options, this.defaultOption);
        }

        @Override
        public @NonNull DropdownComponentImpl translateAndBuild(@NonNull Function<String, String> translator) {
            Preconditions.checkNotNull(translator, "translator");
            this.options.replaceAll(translator::apply);
            return new DropdownComponentImpl(translator.apply(this.text), this.options, this.defaultOption);
        }
    }
}

