/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.packet.Handshake;
import org.geysermc.floodgate.api.handshake.HandshakeData;
import org.geysermc.floodgate.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.player.FloodgateHandshakeHandler;
import org.geysermc.floodgate.util.ReflectionUtils;

public class BungeeProxyDataHandler
extends ChannelInboundHandlerAdapter {
    private static final Field HANDLER = ReflectionUtils.getField(HandlerBoss.class, (String)"handler");
    private static final Field CHANNEL_WRAPPER;
    private final ProxyFloodgateConfig config;
    private final FloodgateHandshakeHandler handler;
    private final AttributeKey<String> kickMessageAttribute;
    private boolean done;

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ReferenceCountUtil.retain((Object)msg);
        if (this.done || !(msg instanceof PacketWrapper)) {
            ctx.fireChannelRead(msg);
            return;
        }
        DefinedPacket packet = ((PacketWrapper)msg).packet;
        if (packet instanceof Handshake) {
            this.handleHandshake(ctx, (Handshake)packet);
            this.done = true;
        }
        ctx.fireChannelRead(msg);
    }

    private void handleHandshake(ChannelHandlerContext ctx, Handshake packet) {
        String data = packet.getHost();
        FloodgateHandshakeHandler.HandshakeResult result = this.handler.handle(ctx.channel(), data);
        HandshakeData handshakeData = result.getHandshakeData();
        InetSocketAddress newIp = result.getNewIp(ctx.channel());
        if (newIp != null) {
            HandlerBoss handlerBoss = (HandlerBoss)ctx.pipeline().get(HandlerBoss.class);
            InitialHandler connection = (InitialHandler)ReflectionUtils.getCastedValue((Object)handlerBoss, (Field)HANDLER);
            ChannelWrapper channelWrapper = (ChannelWrapper)ReflectionUtils.getCastedValue((Object)connection, (Field)CHANNEL_WRAPPER);
            channelWrapper.setRemoteAddress((SocketAddress)newIp);
        }
        if (handshakeData.getDisconnectReason() != null) {
            ctx.channel().attr(this.kickMessageAttribute).set((Object)handshakeData.getDisconnectReason());
            return;
        }
        switch (result.getResultType()) {
            case EXCEPTION: {
                ctx.channel().attr(this.kickMessageAttribute).set((Object)this.config.getDisconnect().getInvalidKey());
                break;
            }
            case INVALID_DATA_LENGTH: {
                ctx.channel().attr(this.kickMessageAttribute).set((Object)this.config.getDisconnect().getInvalidArgumentsLength());
                break;
            }
            case TIMESTAMP_DENIED: {
                ctx.channel().attr(this.kickMessageAttribute).set((Object)"Something isn't right with this data. Try logging in again or contact a server administrator if the issue persists.");
                break;
            }
        }
    }

    public BungeeProxyDataHandler(ProxyFloodgateConfig config, FloodgateHandshakeHandler handler, AttributeKey<String> kickMessageAttribute) {
        this.config = config;
        this.handler = handler;
        this.kickMessageAttribute = kickMessageAttribute;
    }

    static {
        Preconditions.checkNotNull((Object)HANDLER, (Object)"handler field cannot be null");
        CHANNEL_WRAPPER = ReflectionUtils.getFieldOfType(InitialHandler.class, ChannelWrapper.class);
        Preconditions.checkNotNull((Object)CHANNEL_WRAPPER, (Object)"ChannelWrapper field cannot be null");
    }
}

