/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.md_5.bungee.ServerConnector;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.protocol.packet.Handshake;
import org.geysermc.floodgate.api.ProxyFloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.player.FloodgatePlayerImpl;
import org.geysermc.floodgate.util.BedrockData;
import org.geysermc.floodgate.util.ReflectionUtils;

public class BungeeServerDataHandler
extends MessageToMessageEncoder<Object> {
    private static final Field HANDLER = ReflectionUtils.getField(HandlerBoss.class, (String)"handler");
    private static final Field USER_CONNECTION;
    private static final Field CHANNEL_WRAPPER;
    private final ProxyFloodgateConfig config;
    private final ProxyFloodgateApi api;
    private final AttributeKey<FloodgatePlayer> playerAttribute;
    private boolean done;

    protected void encode(ChannelHandlerContext ctx, Object packet, List<Object> out) {
        ReferenceCountUtil.retain((Object)packet);
        if (this.done) {
            out.add(packet);
            return;
        }
        if (!(packet instanceof Handshake) || !this.config.isSendFloodgateData()) {
            this.done = true;
            out.add(packet);
            return;
        }
        HandlerBoss handlerBoss = (HandlerBoss)ctx.pipeline().get(HandlerBoss.class);
        ServerConnector connector = (ServerConnector)ReflectionUtils.getCastedValue((Object)handlerBoss, (Field)HANDLER);
        UserConnection connection = (UserConnection)ReflectionUtils.getCastedValue((Object)connector, (Field)USER_CONNECTION);
        ChannelWrapper wrapper = (ChannelWrapper)ReflectionUtils.getCastedValue((Object)connection, (Field)CHANNEL_WRAPPER);
        FloodgatePlayer player = (FloodgatePlayer)wrapper.getHandle().attr(this.playerAttribute).get();
        if (player != null) {
            BedrockData data = ((FloodgatePlayerImpl)player.as(FloodgatePlayerImpl.class)).toBedrockData();
            String encryptedData = this.api.createEncryptedDataString(data);
            Handshake handshake = (Handshake)packet;
            String address = handshake.getHost();
            int addressFinished = address.indexOf(0);
            String originalAddress = address.substring(0, addressFinished);
            String remaining = address.substring(addressFinished);
            handshake.setHost(originalAddress + '\u0000' + encryptedData + remaining);
        }
        this.done = true;
        out.add(packet);
    }

    public BungeeServerDataHandler(ProxyFloodgateConfig config, ProxyFloodgateApi api, AttributeKey<FloodgatePlayer> playerAttribute) {
        this.config = config;
        this.api = api;
        this.playerAttribute = playerAttribute;
    }

    static {
        Preconditions.checkNotNull((Object)HANDLER, (Object)"handler field cannot be null");
        USER_CONNECTION = ReflectionUtils.getField(ServerConnector.class, (String)"user");
        Preconditions.checkNotNull((Object)USER_CONNECTION, (Object)"user field cannot be null");
        CHANNEL_WRAPPER = ReflectionUtils.getFieldOfType(UserConnection.class, ChannelWrapper.class);
        Preconditions.checkNotNull((Object)CHANNEL_WRAPPER, (Object)"ChannelWrapper field cannot be null");
    }
}

