/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.inject.bungee;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import java.lang.reflect.Field;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.MinecraftEncoder;
import net.md_5.bungee.protocol.Varint21LengthFieldPrepender;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.inject.CommonPlatformInjector;
import org.geysermc.floodgate.util.BungeeReflectionUtils;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class BungeeInjector
extends CommonPlatformInjector {
    private final FloodgateLogger logger;
    private boolean injected;

    public boolean inject() {
        try {
            Field framePrepender = ReflectionUtils.getField(PipelineUtils.class, (String)"framePrepender");
            BungeeCustomPrepender customPrepender = new BungeeCustomPrepender((Varint21LengthFieldPrepender)ReflectionUtils.getCastedValue(null, (Field)framePrepender), this.logger);
            BungeeReflectionUtils.setFieldValue(null, framePrepender, (Object)customPrepender);
            this.injected = true;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean canRemoveInjection() {
        return false;
    }

    public boolean removeInjection() {
        this.logger.error("Floodgate cannot remove itself from Bungee without a reboot", new Object[0]);
        return false;
    }

    public void injectClient(Channel channel, boolean clientToProxy) {
        this.injectAddonsCall(channel, !clientToProxy);
        this.addInjectedClient(channel);
        channel.closeFuture().addListener(listener -> {
            this.channelClosedCall(channel);
            this.removeInjectedClient(channel);
        });
    }

    public BungeeInjector(FloodgateLogger logger) {
        this.logger = logger;
    }

    public boolean isInjected() {
        return this.injected;
    }

    private final class BungeeInjectorInitializer
    extends ChannelInitializer<Channel> {
        private BungeeInjectorInitializer() {
        }

        protected void initChannel(Channel channel) {
            if (!channel.isOpen()) {
                return;
            }
            BungeeInjector.this.injectClient(channel, channel.parent() != null);
        }
    }

    private final class BungeeCustomPrepender
    extends Varint21LengthFieldPrepender {
        private final Varint21LengthFieldPrepender original;
        private final FloodgateLogger logger;

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.original.handlerAdded(ctx);
            ctx.executor().execute(() -> {
                int tries = 0;
                while (ctx.channel().isOpen()) {
                    if (ctx.channel().pipeline().get(MinecraftEncoder.class) != null) {
                        this.logger.debug("found packet encoder :)", new Object[0]);
                        ctx.channel().pipeline().addFirst(new ChannelHandler[]{new BungeeInjectorInitializer()});
                        return;
                    }
                    if (++tries > 25) {
                        this.logger.debug("Failed to inject " + ctx.channel().pipeline(), new Object[0]);
                        return;
                    }
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
        }

        public BungeeCustomPrepender(Varint21LengthFieldPrepender original, FloodgateLogger logger) {
            this.original = original;
            this.logger = logger;
        }
    }
}

