/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.module;

import cloud.commandframework.CommandManager;
import cloud.commandframework.bungee.BungeeCommandManager;
import cloud.commandframework.execution.CommandExecutionCoordinator;
import cloud.commandframework.execution.preprocessor.CommandPreprocessor;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import org.geysermc.floodgate.BungeePlugin;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.inject.CommonPlatformInjector;
import org.geysermc.floodgate.inject.bungee.BungeeInjector;
import org.geysermc.floodgate.listener.BungeeListenerRegistration;
import org.geysermc.floodgate.logger.JavaUtilFloodgateLogger;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.platform.listener.ListenerRegistration;
import org.geysermc.floodgate.platform.pluginmessage.PluginMessageUtils;
import org.geysermc.floodgate.player.FloodgateCommandPreprocessor;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.pluginmessage.BungeePluginMessageRegistration;
import org.geysermc.floodgate.pluginmessage.BungeePluginMessageUtils;
import org.geysermc.floodgate.pluginmessage.BungeeSkinApplier;
import org.geysermc.floodgate.pluginmessage.PluginMessageManager;
import org.geysermc.floodgate.pluginmessage.PluginMessageRegistration;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.util.BungeeCommandUtil;
import org.geysermc.floodgate.util.LanguageManager;

public final class BungeePlatformModule
extends AbstractModule {
    private final BungeePlugin plugin;

    @Provides
    @Singleton
    public Plugin bungeePlugin() {
        return this.plugin;
    }

    @Provides
    @Singleton
    public FloodgateLogger floodgateLogger(LanguageManager languageManager) {
        return new JavaUtilFloodgateLogger(this.plugin.getLogger(), languageManager);
    }

    @Provides
    @Singleton
    public CommandManager<UserAudience> commandManager(CommandUtil commandUtil) {
        BungeeCommandManager commandManager = new BungeeCommandManager((Plugin)this.plugin, CommandExecutionCoordinator.simpleCoordinator(), arg_0 -> ((CommandUtil)commandUtil).getAudience(arg_0), audience -> (CommandSender)audience.source());
        commandManager.registerCommandPreProcessor((CommandPreprocessor)new FloodgateCommandPreprocessor(commandUtil));
        return commandManager;
    }

    @Provides
    @Singleton
    public CommandUtil commandUtil(FloodgateApi api, FloodgateLogger logger, LanguageManager languageManager) {
        return new BungeeCommandUtil(this.plugin.getProxy(), api, logger, languageManager);
    }

    @Provides
    @Singleton
    public ListenerRegistration<Listener> listenerRegistration() {
        return new BungeeListenerRegistration(this.plugin);
    }

    @Provides
    @Singleton
    public PluginMessageUtils pluginMessageUtils(PluginMessageManager manager, FloodgateLogger logger) {
        return new BungeePluginMessageUtils(manager, logger);
    }

    @Provides
    @Singleton
    public PluginMessageRegistration pluginMessageRegistration() {
        return new BungeePluginMessageRegistration();
    }

    @Provides
    @Singleton
    public SkinApplier skinApplier(FloodgateLogger logger) {
        return new BungeeSkinApplier(logger);
    }

    @Provides
    @Singleton
    public CommonPlatformInjector platformInjector(FloodgateLogger logger) {
        return new BungeeInjector(logger);
    }

    @Provides
    @Named(value="packetEncoder")
    public String packetEncoder() {
        return "packet-encoder";
    }

    @Provides
    @Named(value="packetDecoder")
    public String packetDecoder() {
        return "packet-decoder";
    }

    @Provides
    @Named(value="packetHandler")
    public String packetHandler() {
        return "inbound-boss";
    }

    @Provides
    @Named(value="implementationName")
    public String implementationName() {
        return "Bungeecord";
    }

    public BungeePlatformModule(BungeePlugin plugin) {
        this.plugin = plugin;
    }
}

