/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.platform.command.TranslatableMessage;
import org.geysermc.floodgate.player.UserAudience;

public class BungeeUserAudience
implements UserAudience,
ForwardingAudience.Single {
    private final UUID uuid;
    private final String locale;
    private final CommandSender source;
    private final CommandUtil commandUtil;

    public @NonNull UUID uuid() {
        return this.uuid;
    }

    public @NonNull String username() {
        return this.source.getName();
    }

    public @NonNull String locale() {
        return this.locale;
    }

    public @NonNull CommandSender source() {
        return this.source;
    }

    public boolean hasPermission(@NonNull String permission) {
        return this.source.hasPermission(permission);
    }

    public void sendMessage(@NonNull Identity source, @NonNull Component message, @NonNull MessageType type) {
        this.source.sendMessage((String)GsonComponentSerializer.gson().serialize(message));
    }

    public void sendMessage(TranslatableMessage message, Object ... args) {
        this.commandUtil.sendMessage((Object)this.source(), this.locale(), message, args);
    }

    public void disconnect(@NonNull Component reason) {
        if (this.source instanceof ProxiedPlayer) {
            ((ProxiedPlayer)this.source).disconnect((String)GsonComponentSerializer.gson().serialize(reason));
        }
    }

    public void disconnect(TranslatableMessage message, Object ... args) {
        this.commandUtil.kickPlayer((Object)this.source(), this.locale(), message, args);
    }

    public @NonNull Audience audience() {
        return this;
    }

    public BungeeUserAudience(UUID uuid, String locale, CommandSender source, CommandUtil commandUtil) {
        this.uuid = uuid;
        this.locale = locale;
        this.source = source;
        this.commandUtil = commandUtil;
    }

    public static final class BungeePlayerAudience
    extends BungeeUserAudience
    implements UserAudience.PlayerAudience {
        private final String username;
        private final boolean online;

        public BungeePlayerAudience(UUID uuid, String username, String locale, CommandSender source, boolean online, CommandUtil commandUtil) {
            super(uuid, locale, source, commandUtil);
            this.username = username;
            this.online = online;
        }

        public BungeePlayerAudience(UUID uuid, String locale, CommandSender source, boolean online, CommandUtil commandUtil) {
            this(uuid, source.getName(), locale, source, online, commandUtil);
        }

        @Override
        public @NonNull String username() {
            return this.username;
        }

        public boolean online() {
            return this.online;
        }
    }

    public static final class BungeeConsoleAudience
    extends BungeeUserAudience
    implements UserAudience.ConsoleAudience {
        public BungeeConsoleAudience(CommandSender source, CommandUtil commandUtil) {
            super(new UUID(0L, 0L), "en_us", source, commandUtil);
        }

        @Override
        public void sendMessage(@NonNull Identity source, @NonNull Component message, @NonNull MessageType type) {
            this.source().sendMessage(BungeeComponentSerializer.get().serialize(message));
        }
    }
}

