/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.packet.Handshake;
import org.geysermc.floodgate.addon.data.PacketBlocker;
import org.geysermc.floodgate.api.handshake.HandshakeData;
import org.geysermc.floodgate.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.player.FloodgateHandshakeHandler;
import org.geysermc.floodgate.util.ReflectionUtils;

public class BungeeProxyDataHandler
extends ChannelInboundHandlerAdapter {
    private static final Field HANDLER = ReflectionUtils.getField(HandlerBoss.class, (String)"handler");
    private static final Field CHANNEL_WRAPPER;
    private final ProxyFloodgateConfig config;
    private final FloodgateHandshakeHandler handler;
    private final PacketBlocker blocker;
    private final AttributeKey<String> kickMessageAttribute;
    private final Queue<Object> packetQueue = Queues.newConcurrentLinkedQueue();

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        DefinedPacket packet;
        if (!this.packetQueue.isEmpty()) {
            this.packetQueue.add(msg);
            return;
        }
        if (msg instanceof PacketWrapper && (packet = ((PacketWrapper)msg).packet) instanceof Handshake) {
            this.blocker.enable();
            this.packetQueue.add(msg);
            this.handleHandshake(ctx, (Handshake)packet).thenRun(() -> {
                Object queuedPacket;
                while ((queuedPacket = this.packetQueue.poll()) != null) {
                    ctx.fireChannelRead(queuedPacket);
                }
                ctx.pipeline().remove((ChannelHandler)this);
                this.blocker.disable();
            });
            return;
        }
        ctx.fireChannelRead(msg);
    }

    private CompletableFuture<Void> handleHandshake(ChannelHandlerContext ctx, Handshake packet) {
        String data = packet.getHost();
        return ((CompletableFuture)this.handler.handle(ctx.channel(), data).thenAccept(result -> {
            HandshakeData handshakeData = result.getHandshakeData();
            InetSocketAddress newIp = result.getNewIp(ctx.channel());
            if (newIp != null) {
                HandlerBoss handlerBoss = (HandlerBoss)ctx.pipeline().get(HandlerBoss.class);
                InitialHandler connection = (InitialHandler)ReflectionUtils.getCastedValue((Object)handlerBoss, (Field)HANDLER);
                ChannelWrapper channelWrapper = (ChannelWrapper)ReflectionUtils.getCastedValue((Object)connection, (Field)CHANNEL_WRAPPER);
                channelWrapper.setRemoteAddress((SocketAddress)newIp);
            }
            packet.setHost(handshakeData.getHostname());
            if (handshakeData.getDisconnectReason() != null) {
                ctx.channel().attr(this.kickMessageAttribute).set((Object)handshakeData.getDisconnectReason());
                return;
            }
            switch (result.getResultType()) {
                case EXCEPTION: {
                    ctx.channel().attr(this.kickMessageAttribute).set((Object)"An internal error happened while handling Floodgate data. Try logging in again or contact a server administrator if the issue persists.");
                    break;
                }
                case DECRYPT_ERROR: {
                    ctx.channel().attr(this.kickMessageAttribute).set((Object)this.config.getDisconnect().getInvalidKey());
                    break;
                }
                case INVALID_DATA_LENGTH: {
                    ctx.channel().attr(this.kickMessageAttribute).set((Object)this.config.getDisconnect().getInvalidArgumentsLength());
                    break;
                }
            }
        })).handle((v, error) -> {
            if (error != null) {
                error.printStackTrace();
            }
            return v;
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        if (this.config.isDebug()) {
            cause.printStackTrace();
        }
    }

    public BungeeProxyDataHandler(ProxyFloodgateConfig config, FloodgateHandshakeHandler handler, PacketBlocker blocker, AttributeKey<String> kickMessageAttribute) {
        this.config = config;
        this.handler = handler;
        this.blocker = blocker;
        this.kickMessageAttribute = kickMessageAttribute;
    }

    static {
        Preconditions.checkNotNull((Object)HANDLER, (Object)"handler field cannot be null");
        CHANNEL_WRAPPER = ReflectionUtils.getFieldOfType(InitialHandler.class, ChannelWrapper.class);
        Preconditions.checkNotNull((Object)CHANNEL_WRAPPER, (Object)"ChannelWrapper field cannot be null");
    }
}

